/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.advanced;

import org.eclipse.persistence.jpa.JpaEntityManager;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.jpa.advanced.Employee;
import org.eclipse.persistence.testing.models.jpa.advanced.ModelExamples;
import org.eclipse.persistence.testing.models.jpa.advanced.Project;
import org.eclipse.persistence.testing.tests.jpa.EntityContainerTestBase;

public class EMModifyAndRefreshTest
extends EntityContainerTestBase {
    public Integer[] empIDs = new Integer[2];
    public Integer[] projIDs = new Integer[3];

    public EMModifyAndRefreshTest() {
        this.setDescription("Test modify and refresh in EntityManager");
    }

    @Override
    public void setup() {
        super.setup();
        Employee employee = ModelExamples.employeeExample1();
        Project project = ModelExamples.projectExample1();
        try {
            this.beginTransaction();
            this.getEntityManager().persist((Object)employee);
            this.getEntityManager().persist((Object)project);
            this.commitTransaction();
        }
        catch (Exception ex) {
            this.rollbackTransaction();
            ex.printStackTrace();
            throw new TestErrorException("Exception thrown durring persist and flush" + ex);
        }
        this.empIDs[0] = employee.getId();
        this.projIDs[0] = project.getId();
    }

    public void test() {
        try {
            this.beginTransaction();
            Employee employee = (Employee)this.getEntityManager().find(Employee.class, (Object)this.empIDs[0]);
            employee.setFirstName("Tobin");
            employee.setSalary(20000);
            this.getEntityManager().refresh((Object)employee);
            Project project = (Project)this.getEntityManager().find(Project.class, (Object)this.projIDs[0]);
            project.setDescription("To reevaluate the plan");
            project.setName("Reassessment");
            this.getEntityManager().refresh((Object)project);
            this.commitTransaction();
        }
        catch (Exception ex) {
            this.rollbackTransaction();
            ex.printStackTrace();
            throw new TestErrorException("Exception thrown durring persist and flush" + ex);
        }
    }

    public void verify() {
        Employee employee = (Employee)this.getEntityManager().find(Employee.class, (Object)this.empIDs[0]);
        if (employee.getFirstName().equals("Tobin")) {
            throw new TestErrorException("Employee ID :" + this.empIDs[0] + " first name updated after refresh");
        }
        if (employee.getSalary() == 20000) {
            throw new TestErrorException("Employee ID :" + this.empIDs[0] + " salary updated after refresh");
        }
        Project project = (Project)this.getEntityManager().find(Project.class, (Object)this.projIDs[0]);
        if (project.getDescription().equals("To reevaluate the plan")) {
            throw new TestErrorException("Project ID :" + this.projIDs[0] + " description updated after refresh");
        }
        if (project.getName().equals("Reassessment")) {
            throw new TestErrorException("Project ID :" + this.projIDs[0] + " name updated after refresh");
        }
        ((JpaEntityManager)this.getEntityManager()).getActiveSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        employee = (Employee)this.getEntityManager().find(Employee.class, (Object)this.empIDs[0]);
        if (employee.getFirstName().equals("Tobin")) {
            throw new TestErrorException("Employee ID :" + this.empIDs[0] + " first name updated after refresh");
        }
        if (employee.getSalary() == 20000) {
            throw new TestErrorException("Employee ID :" + this.empIDs[0] + " salary updated after refresh");
        }
        project = (Project)this.getEntityManager().find(Project.class, (Object)this.projIDs[0]);
        if (project.getDescription().equals("To reevaluate the plan")) {
            throw new TestErrorException("Project ID :" + this.projIDs[0] + " description updated after refresh");
        }
        if (project.getName().equals("Reassessment")) {
            throw new TestErrorException("Project ID :" + this.projIDs[0] + " name updated after refresh");
        }
    }
}

