/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.eis;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.internal.sessions.CollectionChangeRecord;
import org.eclipse.persistence.internal.sessions.ObjectChangeSet;
import org.eclipse.persistence.mappings.DatabaseMapping;

public class EISCollectionChangeRecord
extends CollectionChangeRecord
implements org.eclipse.persistence.sessions.changesets.EISCollectionChangeRecord {
    private List adds;
    private List removes;
    private List changedMapKeys;

    public EISCollectionChangeRecord(ObjectChangeSet owner, String attributeName, DatabaseMapping mapping) {
        this.owner = owner;
        this.attribute = attributeName;
        this.mapping = mapping;
    }

    public void addAddedChangeSet(Object changeSet) {
        this.getAdds().add(changeSet);
    }

    public void addChangedMapKeyChangeSet(Object changeSet) {
        this.getChangedMapKeys().add(changeSet);
    }

    public void addRemovedChangeSet(Object changeSet) {
        this.getRemoves().add(changeSet);
    }

    public List getAdds() {
        if (this.adds == null) {
            this.adds = new ArrayList(2);
        }
        return this.adds;
    }

    @Override
    public List getChangedMapKeys() {
        if (this.changedMapKeys == null) {
            this.changedMapKeys = new ArrayList(2);
        }
        return this.changedMapKeys;
    }

    public List getRemoves() {
        if (this.removes == null) {
            this.removes = new ArrayList(2);
        }
        return this.removes;
    }

    private boolean hasAdds() {
        return this.adds != null && !this.adds.isEmpty();
    }

    private boolean hasChangedMapKeys() {
        return this.changedMapKeys != null && !this.changedMapKeys.isEmpty();
    }

    @Override
    public boolean hasChanges() {
        return this.hasAdds() || this.hasRemoves() || this.hasChangedMapKeys() || this.getOwner().isNew();
    }

    private boolean hasRemoves() {
        return this.removes != null && !this.removes.isEmpty();
    }

    private boolean removeAddedChangeSet(Object changeSet) {
        if (this.adds == null) {
            return false;
        }
        return this.adds.remove(changeSet);
    }

    private boolean removeRemovedChangeSet(Object changeSet) {
        if (this.removes == null) {
            return false;
        }
        return this.removes.remove(changeSet);
    }

    public void simpleAddChangeSet(Object changeSet) {
        if (!this.removeRemovedChangeSet(changeSet)) {
            this.addAddedChangeSet(changeSet);
        }
    }

    public void simpleRemoveChangeSet(Object changeSet) {
        if (!this.removeAddedChangeSet(changeSet)) {
            this.addRemovedChangeSet(changeSet);
        }
    }
}

