/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.security.ssl;

import java.security.Principal;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.security.auth.x500.X500Principal;

class SSLPatternMatcher {
    private final Pattern pattern;

    SSLPatternMatcher(String regexPattern) {
        this.pattern = Pattern.compile(regexPattern);
    }

    boolean verifyPeer(SSLSession sslSession) {
        X500Principal x500Principal;
        String name;
        Matcher m;
        Principal principal = null;
        try {
            principal = sslSession.getPeerPrincipal();
        }
        catch (SSLPeerUnverifiedException pue) {
            return false;
        }
        return principal != null && principal instanceof X500Principal && (m = this.pattern.matcher(name = (x500Principal = (X500Principal)principal).getName("RFC1779"))).matches();
    }
}

