/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.framework;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.testing.framework.PerformanceComparisonTest;
import org.eclipse.persistence.testing.framework.PerformanceComparisonTestCase;
import org.eclipse.persistence.testing.framework.PerformanceComparisonTestResult;

public abstract class ConcurrentPerformanceComparisonTest
extends PerformanceComparisonTestCase {
    public static double NUMBER_OF_CPUS = 1.1;
    public static int DEFAULT_THREADS = 32;
    protected int minThreads = 2;
    protected int maxThreads = DEFAULT_THREADS;
    protected Exception caughtException;
    protected List workerThreads;

    public int getMaxThreads() {
        return this.maxThreads;
    }

    public void setMaxThreads(int maxThreads) {
        this.maxThreads = maxThreads;
    }

    @Override
    public synchronized void resetIterations() {
        this.iterations = 0;
    }

    @Override
    public void startTest() {
        this.startTest(1);
    }

    public void startTest(int numberOfThreads) {
        this.caughtException = null;
        for (int index = 0; index < numberOfThreads - 1; ++index) {
            WorkerThread thread = (WorkerThread)this.getWorkerThreads().get(index);
            thread.resumeExecution();
        }
    }

    @Override
    public void endTest() {
        WorkerThread thread;
        int index;
        for (index = 0; index < this.getMaxThreads(); ++index) {
            thread = (WorkerThread)this.getWorkerThreads().get(index);
            thread.suspendExecution();
        }
        Thread.yield();
        for (index = 0; index < this.getMaxThreads(); ++index) {
            thread = (WorkerThread)this.getWorkerThreads().get(index);
            thread.joinExecution();
        }
    }

    public List getWorkerThreads() {
        return this.workerThreads;
    }

    @Override
    public void setup() {
        for (int threads = this.minThreads; threads <= this.getMaxThreads(); threads *= 2) {
            this.addThreadTest(threads);
        }
        this.workerThreads = new ArrayList(this.getMaxThreads());
        for (int index = 0; index < this.getMaxThreads(); ++index) {
            WorkerThread thread = new WorkerThread();
            this.workerThreads.add(thread);
            thread.start();
        }
    }

    @Override
    public void test() throws Exception {
        this.test(1);
    }

    public void test(int numberOfThreads) throws Exception {
        if (this.caughtException != null) {
            throw this.caughtException;
        }
        this.runTask();
    }

    @Override
    public void reset() {
        for (int index = 0; index < this.getWorkerThreads().size(); ++index) {
            WorkerThread thread = (WorkerThread)this.getWorkerThreads().get(index);
            thread.stopExecution();
        }
        Thread.yield();
        this.workerThreads = null;
    }

    @Override
    public void verify() {
        PerformanceComparisonTestResult result = (PerformanceComparisonTestResult)this.getTestResult();
        for (int index = 0; index < result.percentageDifferences.size(); ++index) {
            PerformanceComparisonTest test = (PerformanceComparisonTest)this.getTests().get(index);
            double allowable = Math.max(Math.min(NUMBER_OF_CPUS, (double)(index + 1)), NUMBER_OF_CPUS) * 100.0 - 100.0 + this.getAllowableDecrease() * (double)(index + 1);
            test.setAllowableDecrease(allowable);
        }
        super.verify();
    }

    public abstract void runTask() throws Exception;

    public void addThreadTest(final int numberOfThreads) {
        PerformanceComparisonTestCase test = new PerformanceComparisonTestCase(){

            @Override
            public void startTest() {
                ConcurrentPerformanceComparisonTest.this.startTest(numberOfThreads);
            }

            @Override
            public void test() throws Exception {
                ConcurrentPerformanceComparisonTest.this.test(numberOfThreads);
            }

            @Override
            public void endTest() {
                ConcurrentPerformanceComparisonTest.this.endTest();
            }
        };
        test.setName("ThreadTest:" + numberOfThreads);
        this.addTest(test);
    }

    protected class WorkerThread
    extends Thread {
        protected volatile boolean isSuspended = true;
        protected volatile boolean isDead = false;

        protected WorkerThread() {
        }

        public void stopExecution() {
            this.isDead = true;
        }

        public void suspendExecution() {
            this.isSuspended = true;
        }

        public synchronized void joinExecution() {
            if (!this.isSuspended) {
                throw new RuntimeException("Must suspend first");
            }
        }

        public synchronized void resumeExecution() {
            this.isSuspended = false;
            try {
                this.notify();
            }
            catch (Exception exception) {
                throw new RuntimeException(exception.getMessage());
            }
        }

        @Override
        public synchronized void run() {
            try {
                while (!this.isDead) {
                    if (this.isSuspended) {
                        this.wait();
                    }
                    ConcurrentPerformanceComparisonTest.this.runTask();
                    ConcurrentPerformanceComparisonTest.this.incrementIterations();
                }
            }
            catch (Exception exception) {
                ConcurrentPerformanceComparisonTest.this.caughtException = exception;
            }
        }
    }
}

