/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.sessionbroker;

import org.eclipse.persistence.platform.database.DatabasePlatform;
import org.eclipse.persistence.platform.server.CustomServerPlatform;
import org.eclipse.persistence.platform.server.ServerPlatform;
import org.eclipse.persistence.sessions.DatabaseLogin;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.broker.SessionBroker;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.OracleDBPlatformHelper;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.transaction.JTATransactionController;

public class ExternalTransactionControllerInitializationTest
extends AutoVerifyTestCase {
    protected SessionBroker broker = null;

    public ExternalTransactionControllerInitializationTest() {
        this.setDescription("Ensure external transaction controllers are initialized at login time for SessionBrokers.");
    }

    public static DatabaseLogin getLogin1() {
        DatabaseLogin login = new DatabaseLogin();
        try {
            login.usePlatform((DatabasePlatform)OracleDBPlatformHelper.getInstance().getOracle9Platform());
        }
        catch (Exception exception) {
            // empty catch block
        }
        login.useOracleThinJDBCDriver();
        login.setDatabaseURL("ottvm028.ca.oracle.com:1521:toplink");
        login.setUserName("QA7");
        login.setPassword("password");
        login.useNativeSequencing();
        login.getDefaultSequence().setPreallocationSize(1);
        return login;
    }

    public void test() {
        this.broker = new SessionBroker();
        CustomServerPlatform platform = new CustomServerPlatform((DatabaseSession)this.broker);
        platform.setExternalTransactionControllerClass(JTATransactionController.class);
        this.broker.setServerPlatform((ServerPlatform)platform);
        this.broker.setSessionLog(this.getSession().getSessionLog());
        this.broker.login();
    }

    public void verify() {
        if (!this.broker.hasExternalTransactionController()) {
            throw new TestErrorException("SessionBroker's external transaction controller was not initialized on login.");
        }
    }

    public void reset() {
        if (this.broker != null) {
            this.broker.logout();
        }
    }
}

