/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.framework.junit;

import java.io.StringWriter;
import java.io.Writer;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.LockModeType;
import javax.persistence.Persistence;
import javax.rmi.PortableRemoteObject;
import junit.framework.TestCase;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.internal.databaseaccess.DatabasePlatform;
import org.eclipse.persistence.internal.databaseaccess.Platform;
import org.eclipse.persistence.internal.jpa.EntityManagerFactoryImpl;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.DatabaseSessionImpl;
import org.eclipse.persistence.jpa.JpaEntityManager;
import org.eclipse.persistence.logging.DefaultSessionLog;
import org.eclipse.persistence.logging.SessionLog;
import org.eclipse.persistence.sessions.Connector;
import org.eclipse.persistence.sessions.DefaultConnector;
import org.eclipse.persistence.sessions.JNDIConnector;
import org.eclipse.persistence.sessions.broker.SessionBroker;
import org.eclipse.persistence.sessions.server.ServerSession;
import org.eclipse.persistence.testing.framework.junit.JUnitTestCaseHelper;
import org.eclipse.persistence.testing.framework.server.JEEPlatform;
import org.eclipse.persistence.testing.framework.server.ServerPlatform;
import org.eclipse.persistence.testing.framework.server.TestRunner;
import org.eclipse.persistence.testing.framework.server.TestRunner1;
import org.eclipse.persistence.testing.framework.server.TestRunner2;
import org.eclipse.persistence.testing.framework.server.TestRunner3;
import org.eclipse.persistence.testing.framework.server.TestRunner4;
import org.eclipse.persistence.testing.framework.server.TestRunner5;

public abstract class JUnitTestCase
extends TestCase {
    private static Map<String, EntityManagerFactory> emfNamedPersistenceUnits = null;
    private static String DEFAULT_PU_NAME = "default";
    protected static Boolean isOnServer;
    public static Boolean isJTA;
    protected static ServerPlatform serverPlatform;
    public Boolean shouldRunTestOnServer;
    public static final String RUN_ON_SERVER = "server.run";
    public String puName = null;
    protected static boolean isInitialzied;
    public static boolean isOSGi;
    public static Boolean usesSOP;
    public static Boolean isSOPRecoverable;

    public static void initializePlatform() {
        if (isInitialzied) {
            return;
        }
        ServerPlatform platform = JUnitTestCase.getServerPlatform();
        if (platform != null) {
            platform.initialize();
        }
        isInitialzied = true;
    }

    public JUnitTestCase() {
        JUnitTestCase.initializePlatform();
    }

    public JUnitTestCase(String name) {
        super(name);
        JUnitTestCase.initializePlatform();
    }

    public String getPersistenceUnitName() {
        return DEFAULT_PU_NAME;
    }

    public boolean shouldRunTestOnServer() {
        if (this.shouldRunTestOnServer == null) {
            String property = System.getProperty(RUN_ON_SERVER);
            this.shouldRunTestOnServer = property != null ? Boolean.valueOf(property.toUpperCase().equals("TRUE")) : Boolean.valueOf(false);
        }
        return this.shouldRunTestOnServer;
    }

    public static boolean isJTA() {
        String property = System.getProperty("is.JTA");
        isJTA = property != null && property.toUpperCase().equals("FALSE") ? Boolean.valueOf(false) : Boolean.valueOf(true);
        return isJTA;
    }

    public boolean isWeavingForChangeTrackingEnabled() {
        return this.isWeavingForChangeTrackingEnabled(this.getPersistenceUnitName());
    }

    public boolean isWeavingForChangeTrackingEnabled(String persistenceUnitName) {
        Object changeTrackingWeaving = JUnitTestCase.getDatabaseSession(persistenceUnitName).getProperty("eclipselink.weaving.changetracking");
        if (changeTrackingWeaving == null) {
            changeTrackingWeaving = System.getProperty("eclipselink.weaving.changetracking");
        }
        return !"false".equals(changeTrackingWeaving);
    }

    public boolean isWeavingForFetchGroupsEnabled() {
        return this.isWeavingForFetchGroupsEnabled(this.getPersistenceUnitName());
    }

    public boolean isWeavingForFetchGroupsEnabled(String persistenceUnitName) {
        Object fetchGroupsWeaving = JUnitTestCase.getDatabaseSession(persistenceUnitName).getProperty("eclipselink.weaving.fetchgroups");
        if (fetchGroupsWeaving == null) {
            fetchGroupsWeaving = System.getProperty("eclipselink.weaving.fetchgroups");
        }
        return !"false".equals(fetchGroupsWeaving);
    }

    public boolean isWeavingEnabled() {
        return JUnitTestCase.isWeavingEnabled(this.getPersistenceUnitName());
    }

    public static boolean isWeavingEnabled(String persistenceUnitName) {
        return System.getProperty("TEST_NO_WEAVING") == null;
    }

    public static boolean isJPA10() {
        try {
            LockModeType.valueOf((String)"NONE");
        }
        catch (Exception e) {
            return true;
        }
        return false;
    }

    public static boolean isOnServer() {
        if (isOnServer == null) {
            isOnServer = System.getProperty("TEST_SERVER_PLATFORM") != null ? Boolean.valueOf(true) : Boolean.valueOf(false);
        }
        return isOnServer;
    }

    public static void setIsOnServer(boolean value) {
        isOnServer = value;
    }

    public boolean isHermesParser() {
        return this.getDatabaseSession().getQueryBuilder().getClass().getName().indexOf("Hermes") != -1;
    }

    public static boolean usesSOP() {
        if (usesSOP == null) {
            usesSOP = Boolean.valueOf(System.getProperty("sop"));
        }
        return usesSOP;
    }

    public static boolean isSOPRecoverable() {
        if (isSOPRecoverable == null) {
            isSOPRecoverable = Boolean.valueOf(System.getProperty("sop.recoverable"));
        }
        return isSOPRecoverable;
    }

    public static ServerPlatform getServerPlatform() {
        if (serverPlatform == null) {
            String platformClass = System.getProperty("TEST_SERVER_PLATFORM");
            if (platformClass == null) {
                serverPlatform = new JEEPlatform();
            } else {
                try {
                    serverPlatform = (ServerPlatform)Class.forName(platformClass).newInstance();
                }
                catch (Exception notFound) {
                    throw new RuntimeException(notFound);
                }
            }
        }
        return serverPlatform;
    }

    public static void setServerPlatform(ServerPlatform value) {
        serverPlatform = value;
    }

    public void clearCache() {
        try {
            this.getDatabaseSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        }
        catch (Exception ex) {
            throw new RuntimeException("An exception occurred trying clear the database session cache.", ex);
        }
    }

    public void clearServerSessionCache() {
        try {
            JUnitTestCase.getServerSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        }
        catch (Exception ex) {
            throw new RuntimeException("An exception occurred trying clear the server session cache.", ex);
        }
    }

    public static void clearCache(String persistenceUnitName) {
        try {
            JUnitTestCase.getDatabaseSession(persistenceUnitName).getIdentityMapAccessor().initializeAllIdentityMaps();
        }
        catch (Exception ex) {
            throw new RuntimeException("An exception occurred trying clear the database session cache.", ex);
        }
    }

    public static void clearServerSessionCache(String persistenceUnitName) {
        try {
            JUnitTestCase.getServerSession(persistenceUnitName).getIdentityMapAccessor().initializeAllIdentityMaps();
        }
        catch (Exception ex) {
            throw new RuntimeException("An exception occurred trying clear the server session cache.", ex);
        }
    }

    public void closeEntityManager(EntityManager entityManager) {
        if (!JUnitTestCase.isOnServer()) {
            entityManager.close();
        }
    }

    public void closeEntityManagerAndTransaction(EntityManager entityManager) {
        if (this.isTransactionActive(entityManager)) {
            this.rollbackTransaction(entityManager);
        }
        this.closeEntityManager(entityManager);
    }

    public boolean isTransactionActive(EntityManager entityManager) {
        if (JUnitTestCase.isOnServer() && JUnitTestCase.isJTA()) {
            return JUnitTestCase.getServerPlatform().isTransactionActive();
        }
        return entityManager.getTransaction().isActive();
    }

    public boolean getRollbackOnly(EntityManager entityManager) {
        if (JUnitTestCase.isOnServer() && JUnitTestCase.isJTA()) {
            return JUnitTestCase.getServerPlatform().getRollbackOnly();
        }
        return entityManager.getTransaction().getRollbackOnly();
    }

    public void beginTransaction(EntityManager entityManager) {
        if (JUnitTestCase.isOnServer() && JUnitTestCase.isJTA()) {
            JUnitTestCase.getServerPlatform().beginTransaction();
            JUnitTestCase.getServerPlatform().joinTransaction(entityManager);
        } else {
            entityManager.getTransaction().begin();
        }
    }

    public void commitTransaction(EntityManager entityManager) {
        if (JUnitTestCase.isOnServer() && JUnitTestCase.isJTA()) {
            JUnitTestCase.getServerPlatform().commitTransaction();
        } else {
            entityManager.getTransaction().commit();
        }
    }

    public void rollbackTransaction(EntityManager entityManager) {
        if (JUnitTestCase.isOnServer() && JUnitTestCase.isJTA()) {
            JUnitTestCase.getServerPlatform().rollbackTransaction();
        } else {
            entityManager.getTransaction().rollback();
        }
    }

    public EntityManager createEntityManager() {
        if (JUnitTestCase.isOnServer() && JUnitTestCase.isJTA()) {
            return JUnitTestCase.getServerPlatform().getEntityManager(this.getPersistenceUnitName());
        }
        return JUnitTestCase.getEntityManagerFactory(this.getPersistenceUnitName(), this.getPersistenceProperties()).createEntityManager();
    }

    public static EntityManager createEntityManager(String persistenceUnitName) {
        if (JUnitTestCase.isOnServer() && JUnitTestCase.isJTA()) {
            return JUnitTestCase.getServerPlatform().getEntityManager(persistenceUnitName);
        }
        return JUnitTestCase.getEntityManagerFactory(persistenceUnitName).createEntityManager();
    }

    public EntityManager createEntityManager(Map properties) {
        if (JUnitTestCase.isOnServer() && JUnitTestCase.isJTA()) {
            return JUnitTestCase.getServerPlatform().getEntityManager(this.getPersistenceUnitName());
        }
        return JUnitTestCase.getEntityManagerFactory(this.getPersistenceUnitName(), properties).createEntityManager(properties);
    }

    public static EntityManager createEntityManager(String persistenceUnitName, Map properties) {
        return JUnitTestCase.createEntityManager(persistenceUnitName, properties, null);
    }

    public static EntityManager createEntityManager(String persistenceUnitName, Map properties, List<ClassDescriptor> descriptors) {
        if (JUnitTestCase.isOnServer() && JUnitTestCase.isJTA()) {
            return JUnitTestCase.getServerPlatform().getEntityManager(persistenceUnitName);
        }
        return JUnitTestCase.getEntityManagerFactory(persistenceUnitName, properties, descriptors).createEntityManager();
    }

    public DatabaseSessionImpl getDatabaseSession() {
        return ((JpaEntityManager)this.getEntityManagerFactory().createEntityManager()).getDatabaseSession();
    }

    public static DatabaseSessionImpl getDatabaseSession(String persistenceUnitName) {
        return ((JpaEntityManager)JUnitTestCase.getEntityManagerFactory(persistenceUnitName).createEntityManager()).getDatabaseSession();
    }

    public SessionBroker getSessionBroker() {
        return ((JpaEntityManager)this.getEntityManagerFactory().createEntityManager()).getSessionBroker();
    }

    public static SessionBroker getSessionBroker(String persistenceUnitName) {
        return ((JpaEntityManager)JUnitTestCase.getEntityManagerFactory(persistenceUnitName).createEntityManager()).getSessionBroker();
    }

    public static ServerSession getServerSession() {
        return ((JpaEntityManager)JUnitTestCase.getEntityManagerFactory("default").createEntityManager()).getServerSession();
    }

    public static ServerSession getServerSession(String persistenceUnitName) {
        return ((JpaEntityManager)JUnitTestCase.getEntityManagerFactory(persistenceUnitName).createEntityManager()).getServerSession();
    }

    public static ServerSession getServerSession(String persistenceUnitName, Map properties) {
        return ((JpaEntityManager)JUnitTestCase.getEntityManagerFactory(persistenceUnitName, properties).createEntityManager()).getServerSession();
    }

    public ServerSession getPersistenceUnitServerSession() {
        return JUnitTestCase.getServerSession(this.getPersistenceUnitName());
    }

    public Map getPersistenceProperties() {
        return JUnitTestCaseHelper.getDatabaseProperties((String)this.getPersistenceUnitName());
    }

    public static EntityManagerFactory getEntityManagerFactory(String persistenceUnitName) {
        return JUnitTestCase.getEntityManagerFactory(persistenceUnitName, JUnitTestCaseHelper.getDatabaseProperties((String)persistenceUnitName), null);
    }

    public static EntityManagerFactory getEntityManagerFactory(String persistenceUnitName, Map properties) {
        return JUnitTestCase.getEntityManagerFactory(persistenceUnitName, properties, null);
    }

    public static EntityManagerFactory getEntityManagerFactory(String persistenceUnitName, Map properties, List<ClassDescriptor> descriptors) {
        Object emfNamedPersistenceUnit;
        if (JUnitTestCase.isOnServer()) {
            return JUnitTestCase.getServerPlatform().getEntityManagerFactory(persistenceUnitName);
        }
        if (isOSGi && properties.get("eclipselink.classloader") == null) {
            try {
                properties.put("eclipselink.classloader", JUnitTestCase.class.getClassLoader());
            }
            catch (Exception ignore) {
                System.out.println(ignore);
            }
        }
        if ((emfNamedPersistenceUnit = emfNamedPersistenceUnits.get(persistenceUnitName)) == null) {
            if (!persistenceUnitName.equals("default") && emfNamedPersistenceUnits.containsKey("default") && (JUnitTestCase.getServerSession().getPlatform().isSybase() || JUnitTestCase.getServerSession().getPlatform().isMySQL())) {
                Iterator<Map.Entry<String, EntityManagerFactory>> factories = emfNamedPersistenceUnits.entrySet().iterator();
                while (factories.hasNext()) {
                    Map.Entry<String, EntityManagerFactory> entry = factories.next();
                    if (entry.getKey().equals("default") || entry.getKey().equals(persistenceUnitName)) continue;
                    System.out.println("Closing factory: " + entry.getKey());
                    entry.getValue().close();
                    factories.remove();
                }
            }
            emfNamedPersistenceUnit = descriptors == null ? Persistence.createEntityManagerFactory((String)persistenceUnitName, (Map)properties) : new EntityManagerFactoryImpl(persistenceUnitName, properties, descriptors);
            emfNamedPersistenceUnits.put(persistenceUnitName, (EntityManagerFactory)emfNamedPersistenceUnit);
        }
        return emfNamedPersistenceUnit;
    }

    public EntityManagerFactory getEntityManagerFactory() {
        return JUnitTestCase.getEntityManagerFactory(this.getPersistenceUnitName());
    }

    public EntityManagerFactory getEntityManagerFactory(Map properties) {
        return JUnitTestCase.getEntityManagerFactory(this.getPersistenceUnitName(), properties);
    }

    public boolean doesEntityManagerFactoryExist() {
        return JUnitTestCase.doesEntityManagerFactoryExist(this.getPersistenceUnitName());
    }

    public static boolean doesEntityManagerFactoryExist(String persistenceUnitName) {
        EntityManagerFactory emf = emfNamedPersistenceUnits.get(persistenceUnitName);
        return emf != null && emf.isOpen();
    }

    public void closeEntityManagerFactory() {
        JUnitTestCase.closeEntityManagerFactory(this.getPersistenceUnitName());
    }

    public static void closeEntityManagerFactory(String persistenceUnitName) {
        EntityManagerFactory emfNamedPersistenceUnit = emfNamedPersistenceUnits.get(persistenceUnitName);
        if (emfNamedPersistenceUnit != null) {
            if (emfNamedPersistenceUnit.isOpen()) {
                emfNamedPersistenceUnit.close();
            }
            emfNamedPersistenceUnits.remove(persistenceUnitName);
        }
    }

    public Platform getPlatform() {
        return JUnitTestCase.getPlatform(this.getPersistenceUnitName());
    }

    public Platform getPlatform(Class cls) {
        return JUnitTestCase.getPlatform(this.getPersistenceUnitName(), cls);
    }

    public static Platform getPlatform(String puName) {
        return JUnitTestCase.getDatabaseSession(puName).getPlatform();
    }

    public static Platform getPlatform(String puName, Class cls) {
        return JUnitTestCase.getDatabaseSession(puName).getPlatform(cls);
    }

    public void setUp() {
    }

    public void tearDown() {
    }

    public static void warning(String warning) {
        System.out.println("WARNING: " + warning);
    }

    public void runBare() throws Throwable {
        if (this.shouldRunTestOnServer()) {
            this.runBareClient();
        } else {
            super.runBare();
        }
    }

    public void runBareClient() throws Throwable {
        Properties properties = new Properties();
        String url = System.getProperty("server.url");
        if (url == null) {
            JUnitTestCase.fail((String)"System property 'server.url' must be set.");
        }
        properties.put("java.naming.provider.url", url);
        InitialContext context = new InitialContext(properties);
        Throwable exception = null;
        if (this.puName == null) {
            String testrunner = System.getProperty("server.testrunner");
            if (testrunner == null) {
                JUnitTestCase.fail((String)"System property 'server.testrunner' must be set.");
            }
            TestRunner runner = (TestRunner)PortableRemoteObject.narrow((Object)context.lookup(testrunner), TestRunner.class);
            exception = runner.runTest(((Object)((Object)this)).getClass().getName(), this.getName(), this.getServerProperties());
        } else {
            int i = this.puName.charAt(8) - 48;
            String[] testRunner = new String[6];
            for (int j = 1; j <= 5; ++j) {
                String serverRunner = "server.testrunner" + j;
                testRunner[j] = System.getProperty(serverRunner);
                if (testRunner[j] != null) continue;
                JUnitTestCase.fail((String)("System property 'server.testrunner'" + j + " must be set."));
            }
            switch (i) {
                case 1: {
                    TestRunner1 runner1 = (TestRunner1)PortableRemoteObject.narrow((Object)context.lookup(testRunner[1]), TestRunner1.class);
                    exception = runner1.runTest(((Object)((Object)this)).getClass().getName(), this.getName(), this.getServerProperties());
                    break;
                }
                case 2: {
                    TestRunner2 runner2 = (TestRunner2)PortableRemoteObject.narrow((Object)context.lookup(testRunner[2]), TestRunner2.class);
                    exception = runner2.runTest(((Object)((Object)this)).getClass().getName(), this.getName(), this.getServerProperties());
                    break;
                }
                case 3: {
                    TestRunner3 runner3 = (TestRunner3)PortableRemoteObject.narrow((Object)context.lookup(testRunner[3]), TestRunner3.class);
                    exception = runner3.runTest(((Object)((Object)this)).getClass().getName(), this.getName(), this.getServerProperties());
                    break;
                }
                case 4: {
                    TestRunner4 runner4 = (TestRunner4)PortableRemoteObject.narrow((Object)context.lookup(testRunner[4]), TestRunner4.class);
                    exception = runner4.runTest(((Object)((Object)this)).getClass().getName(), this.getName(), this.getServerProperties());
                    break;
                }
                case 5: {
                    TestRunner5 runner5 = (TestRunner5)PortableRemoteObject.narrow((Object)context.lookup(testRunner[5]), TestRunner5.class);
                    exception = runner5.runTest(((Object)((Object)this)).getClass().getName(), this.getName(), this.getServerProperties());
                    break;
                }
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    public void runBareServer() throws Throwable {
        JUnitTestCase.setIsOnServer(true);
        super.runBare();
    }

    protected Properties getServerProperties() {
        return null;
    }

    public void verifyObject(Object writtenObject) {
        JUnitTestCase.verifyObject(writtenObject, this.getPersistenceUnitName());
    }

    public static void verifyObject(Object writtenObject, String persistenceUnit) {
        Object readObject = JUnitTestCase.getDatabaseSession(persistenceUnit).readObject(writtenObject);
        if (!JUnitTestCase.getDatabaseSession(persistenceUnit).compareObjects(readObject, writtenObject)) {
            JUnitTestCase.fail((String)("Object: " + readObject + " does not match object that was written: " + writtenObject + ". See log (on finest) for what did not match."));
        }
    }

    public void verifyObjectInEntityManager(Object writtenObject) {
        this.verifyObjectInEntityManager(writtenObject, this.getPersistenceUnitName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void verifyObjectInEntityManager(Object writtenObject, String persistenceUnit) {
        EntityManager em = JUnitTestCase.createEntityManager(persistenceUnit);
        try {
            Object readObject = em.find(writtenObject.getClass(), JUnitTestCase.getServerSession(persistenceUnit).getId(writtenObject));
            if (!JUnitTestCase.getServerSession(persistenceUnit).compareObjects(readObject, writtenObject)) {
                JUnitTestCase.fail((String)("Object: " + readObject + " does not match object that was written: " + writtenObject + ". See log (on finest) for what did not match."));
            }
        }
        finally {
            this.closeEntityManager(em);
        }
    }

    public void verifyObjectInCacheAndDatabase(Object writtenObject) {
        JUnitTestCase.verifyObjectInCacheAndDatabase(writtenObject, this.getPersistenceUnitName());
    }

    public static void verifyObjectInCacheAndDatabase(Object writtenObject, String persistenceUnit) {
        StringWriter newLog;
        SessionLog oldLog;
        Object readObject;
        DatabaseSessionImpl dbs = JUnitTestCase.getDatabaseSession(persistenceUnit);
        if (!dbs.compareObjects(readObject = dbs.readObject(writtenObject), writtenObject)) {
            oldLog = dbs.getSessionLog();
            dbs.setSessionLog((SessionLog)new DefaultSessionLog());
            dbs.setLogLevel(1);
            newLog = new StringWriter();
            dbs.setLog((Writer)newLog);
            dbs.compareObjects(readObject, writtenObject);
            dbs.setSessionLog(oldLog);
            JUnitTestCase.fail((String)("Object from cache: " + readObject + " does not match object that was written: " + writtenObject + ". " + newLog));
        }
        dbs.getIdentityMapAccessor().initializeAllIdentityMaps();
        readObject = dbs.readObject(writtenObject);
        if (!dbs.compareObjects(readObject, writtenObject)) {
            oldLog = dbs.getSessionLog();
            dbs.setSessionLog((SessionLog)new DefaultSessionLog());
            dbs.setLogLevel(1);
            newLog = new StringWriter();
            dbs.setLog((Writer)newLog);
            dbs.compareObjects(readObject, writtenObject);
            dbs.setSessionLog(oldLog);
            JUnitTestCase.fail((String)("Object from database: " + readObject + " does not match object that was written: " + writtenObject + ". " + newLog));
        }
    }

    public void compareObjects(Object obj1, Object obj2) {
        JUnitTestCase.compareObjects(obj1, obj2, this.getPersistenceUnitName());
    }

    public static void compareObjects(Object obj1, Object obj2, String persistenceUnit) {
        DatabaseSessionImpl dbs = JUnitTestCase.getDatabaseSession(persistenceUnit);
        if (!dbs.compareObjects(obj1, obj2)) {
            JUnitTestCase.fail((String)("Objects " + obj1 + " and " + obj2 + " are not equal. See log (on finest) for what did not match."));
        }
    }

    public void verifyPersist(Object object) {
        EntityManager em = this.createEntityManager();
        try {
            this.beginTransaction(em);
            em.persist(object);
            this.commitTransaction(em);
            this.beginTransaction(em);
            this.verifyObjectInCacheAndDatabase(object);
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
        catch (RuntimeException exception) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw exception;
        }
    }

    public void verifyPersistAndRemove(Object object) {
        EntityManager em = this.createEntityManager();
        try {
            this.beginTransaction(em);
            em.persist(object);
            this.commitTransaction(em);
            this.closeEntityManager(em);
            em = this.createEntityManager();
            this.beginTransaction(em);
            object = em.find(object.getClass(), JUnitTestCase.getServerSession(this.getPersistenceUnitName()).getId(object));
            em.remove(object);
            this.commitTransaction(em);
            this.verifyDelete(object);
            this.closeEntityManager(em);
        }
        catch (RuntimeException exception) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw exception;
        }
    }

    public void verifyDelete(Object writtenObject) {
        this.verifyDelete(writtenObject, this.getPersistenceUnitName());
    }

    public void verifyDelete(Object writtenObject, String persistenceUnit) {
        DatabaseSessionImpl dbs = JUnitTestCase.getDatabaseSession(persistenceUnit);
        boolean ok = dbs.isServerSession() ? ((ServerSession)dbs).acquireClientSession().verifyDelete(writtenObject) : (dbs.isSessionBroker() ? ((SessionBroker)dbs).acquireClientSessionBroker().verifyDelete(writtenObject) : dbs.verifyDelete(writtenObject));
        if (!ok) {
            JUnitTestCase.fail((String)("Object not deleted from the database correctly: " + writtenObject));
        }
    }

    public void logThrowable(Throwable exception) {
        this.getDatabaseSession().getSessionLog().logThrowable(6, exception);
    }

    public boolean isSelectForUpateSupported() {
        return JUnitTestCase.isSelectForUpateSupported(this.getPersistenceUnitName());
    }

    public static boolean isSelectForUpateSupported(String puName) {
        DatabaseSessionImpl dbSession = JUnitTestCase.getDatabaseSession(puName);
        if (dbSession.isBroker()) {
            for (AbstractSession memberSession : ((SessionBroker)dbSession).getSessionsByName().values()) {
                if (JUnitTestCase.isSelectForUpateSupported((DatabasePlatform)memberSession.getPlatform())) continue;
                return false;
            }
            return true;
        }
        return JUnitTestCase.isSelectForUpateSupported((DatabasePlatform)dbSession.getPlatform());
    }

    public static boolean isSelectForUpateSupported(DatabasePlatform platform) {
        if (platform.isFirebird() || platform.isH2() || platform.isHSQL() || platform.isAccess() || platform.isSQLAnywhere() || platform.isDerby() || platform.isPostgreSQL() || platform.isSymfoware()) {
            JUnitTestCase.warning("This database does not support FOR UPDATE.");
            return false;
        }
        return true;
    }

    public boolean isPessimisticWriteLockSupported() {
        return JUnitTestCase.isPessimisticWriteLockSupported(this.getPersistenceUnitName());
    }

    public static boolean isPessimisticWriteLockSupported(String puName) {
        DatabaseSessionImpl dbSession = JUnitTestCase.getDatabaseSession(puName);
        if (dbSession.isBroker()) {
            for (AbstractSession memberSession : ((SessionBroker)dbSession).getSessionsByName().values()) {
                if (JUnitTestCase.isPessimisticWriteLockSupported((DatabasePlatform)memberSession.getPlatform())) continue;
                return false;
            }
            return true;
        }
        return JUnitTestCase.isPessimisticWriteLockSupported((DatabasePlatform)dbSession.getPlatform());
    }

    public static boolean isPessimisticWriteLockSupported(DatabasePlatform platform) {
        if (platform.isSybase()) {
            JUnitTestCase.warning("This database does not support Pessimistic Write Lock.");
            return false;
        }
        return true;
    }

    public static boolean isSelectForUpateNoWaitSupported(String puName) {
        DatabaseSessionImpl dbSession = JUnitTestCase.getDatabaseSession(puName);
        if (dbSession.isBroker()) {
            for (AbstractSession memberSession : ((SessionBroker)dbSession).getSessionsByName().values()) {
                if (JUnitTestCase.isSelectForUpateNoWaitSupported((Platform)memberSession.getPlatform())) continue;
                return false;
            }
            return true;
        }
        return JUnitTestCase.isSelectForUpateNoWaitSupported((Platform)dbSession.getPlatform());
    }

    public boolean isSelectForUpateNoWaitSupported() {
        return JUnitTestCase.isSelectForUpateNoWaitSupported(this.getPersistenceUnitName());
    }

    public static boolean isSelectForUpateNoWaitSupported(Platform platform) {
        if (platform.isOracle() || platform.isSQLServer()) {
            return true;
        }
        JUnitTestCase.warning("This database does not support NOWAIT.");
        return false;
    }

    public static boolean supportsSequenceObjects(String puName) {
        org.eclipse.persistence.platform.database.DatabasePlatform platform = JUnitTestCase.getDatabaseSession(puName).getPlatform();
        return platform.supportsSequenceObjects();
    }

    public boolean supportsSequenceObjects() {
        org.eclipse.persistence.platform.database.DatabasePlatform platform = JUnitTestCase.getDatabaseSession(this.getPersistenceUnitName()).getPlatform();
        return platform.supportsSequenceObjects();
    }

    public boolean supportsStoredProcedures() {
        return JUnitTestCase.supportsStoredProcedures(this.getPersistenceUnitName());
    }

    public static boolean supportsStoredProcedures(String puName) {
        org.eclipse.persistence.platform.database.DatabasePlatform platform = JUnitTestCase.getDatabaseSession(puName).getPlatform();
        if (platform.isOracle() || platform.isMySQL() || platform.isSQLServer()) {
            return true;
        }
        JUnitTestCase.warning("This database does not support stored procedure creation.");
        return false;
    }

    public boolean supportsStoredFunctions() {
        return JUnitTestCase.supportsStoredFunctions(this.getPersistenceUnitName());
    }

    public static boolean supportsStoredFunctions(String puName) {
        org.eclipse.persistence.platform.database.DatabasePlatform platform = JUnitTestCase.getDatabaseSession(puName).getPlatform();
        if (platform.isOracle() || platform.isMySQL()) {
            return true;
        }
        JUnitTestCase.warning("This database does not support stored function creation.");
        return false;
    }

    public void setPuName(String name) {
        this.puName = name;
    }

    public static boolean usingTheSameDatabase(AbstractSession session1, AbstractSession session2) {
        Connector conn1 = session1.getLogin().getConnector();
        Connector conn2 = session2.getLogin().getConnector();
        if (conn1 instanceof DefaultConnector && conn2 instanceof DefaultConnector) {
            return ((DefaultConnector)conn1).getDatabaseURL().equals(((DefaultConnector)conn2).getDatabaseURL());
        }
        if (conn1 instanceof JNDIConnector && conn2 instanceof JNDIConnector) {
            String name1 = ((JNDIConnector)conn1).getName();
            String name2 = ((JNDIConnector)conn2).getName();
            if (name1 != null && name1.equals(name2)) {
                return true;
            }
            return ((JNDIConnector)conn1).getDataSource().equals(((JNDIConnector)conn2).getDataSource());
        }
        return false;
    }

    static {
        isJTA = true;
        emfNamedPersistenceUnits = new Hashtable<String, EntityManagerFactory>();
        isOSGi = false;
    }
}

