/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.unitofwork;

import java.util.Vector;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.inheritance.Bus;
import org.eclipse.persistence.testing.models.inheritance.Company;
import org.eclipse.persistence.testing.models.inheritance.Person;

public class RelationshipTreeInsertTest
extends AutoVerifyTestCase {
    public RelationshipTreeInsertTest() {
        this.setName("RelationshipTreeInsertTest");
        this.setDescription("");
    }

    public void setup() {
        this.getAbstractSession().beginTransaction();
    }

    public void reset() {
        this.getAbstractSession().rollbackTransaction();
    }

    public void test() {
        Company company = new Company();
        company.setName("School Bus Services");
        Person busDriver = new Person();
        busDriver.setName("Otto");
        Bus bus = new Bus();
        bus.setDescription("School bus");
        bus.busDriver = busDriver;
        Vector<Bus> vehicles = new Vector<Bus>();
        vehicles.addElement(bus);
        company.getVehicles().setValue(vehicles);
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        uow.registerObject((Object)company);
        uow.commit();
    }

    public void verify() {
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        ExpressionBuilder builder1 = new ExpressionBuilder();
        Expression exp1 = builder1.get("name").equal((Object)"Otto");
        ReadObjectQuery query1 = new ReadObjectQuery(Person.class, exp1);
        Person personFromDB = (Person)this.getSession().executeQuery((DatabaseQuery)query1);
        if (personFromDB == null) {
            throw new TestErrorException("UnitOfWork did not write the Company's Bus' busDriver.");
        }
    }
}

