/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.framework;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.testing.framework.LoadBuildSystem;
import org.eclipse.persistence.testing.framework.PerformanceComparisonTest;
import org.eclipse.persistence.testing.framework.PerformanceRegressionTest;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestResult;

public class PerformanceComparisonTestResult
extends TestResult {
    public List testCounts = new ArrayList();
    public List testAverages = new ArrayList();
    public List testMaxs = new ArrayList();
    public List testMins = new ArrayList();
    public List testStandardDeviations = new ArrayList();
    public List percentageDifferences = new ArrayList();
    public double averageTestCount;
    protected double percentageDifferenceLastRun;
    protected double percentageDifferenceAverage;
    protected String baselineVersion;
    public List currentVersionResults = new ArrayList();
    public List baselineVersionResults = new ArrayList();
    public double baselineStandardDeviation;
    public double currentStandardDeviation;

    public PerformanceComparisonTestResult() {
    }

    public PerformanceComparisonTestResult(TestCase testCase) {
        super(testCase);
    }

    public PerformanceComparisonTestResult(TestCase testCase, String result) {
        super(testCase, result);
    }

    public double getAverageTestCount() {
        return this.averageTestCount;
    }

    public void setAverageTestCount(double averageTestCount) {
        this.averageTestCount = averageTestCount;
        this.testTime = (long)averageTestCount;
    }

    public double getPercentageDifferenceLastRun() {
        return this.percentageDifferenceLastRun;
    }

    public double getPercentageDifferenceAverage() {
        return this.percentageDifferenceAverage;
    }

    public String getBaselineVersion() {
        return this.baselineVersion;
    }

    public void computeResults() {
        for (int testIndex = 0; testIndex < this.getTestCounts().size(); ++testIndex) {
            List times = (List)this.getTestCounts().get(testIndex);
            double testAverage = PerformanceComparisonTestResult.averageResults(times);
            double testStandardDeviation = PerformanceComparisonTestResult.standardDeviationResults(times);
            this.setAverageTestCount((long)testAverage);
            this.testAverages.add(new Double(testAverage));
            this.testMins.add(PerformanceComparisonTestResult.minResults(times));
            this.testMaxs.add(PerformanceComparisonTestResult.maxResults(times));
            this.testStandardDeviations.add(new Double(testStandardDeviation));
            if (testIndex <= 0) continue;
            double testBaseLineAverage = ((Number)this.testAverages.get(0)).doubleValue();
            double percentageDifference = PerformanceComparisonTestResult.percentageDifference(testAverage, testBaseLineAverage);
            this.percentageDifferences.add(new Double(percentageDifference));
        }
    }

    public List getTestCounts() {
        return this.testCounts;
    }

    public List getCurrentVersionResults() {
        return this.currentVersionResults;
    }

    public List getBaselineVersionResults() {
        return this.baselineVersionResults;
    }

    public void addTestCount(long time, int test) {
        if (this.getTestCounts().size() <= test) {
            this.getTestCounts().add(new ArrayList());
        }
        ((List)this.getTestCounts().get(test)).add(new Long(time));
    }

    @Override
    public boolean shouldLogResult() {
        return true;
    }

    @Override
    public void logResult(Writer log) {
        String indentationString = this.getTestCase().getIndentationString();
        try {
            if (this.hasError() || this.hasFatalError() || this.hasProblem()) {
                log.write(indentationString + "##FAILURE##" + Helper.cr());
            }
            if (!this.getTestCounts().isEmpty()) {
                log.write(indentationString + "RUNS:                    " + ((List)this.getTestCounts().get(0)).size() + Helper.cr());
            }
            for (int index = 0; index < this.getTestCounts().size(); ++index) {
                PerformanceComparisonTest test = (PerformanceComparisonTest)((Object)this.testCase);
                log.write(Helper.cr());
                if (index == 0) {
                    log.write(indentationString + "BASE_LINE TEST" + Helper.cr());
                } else {
                    test = (PerformanceComparisonTest)test.getTests().get(index - 1);
                }
                log.write(indentationString + "TEST: " + test.getName() + Helper.cr());
                log.write(indentationString + "TEST RUN TIME:                " + test.getTestRunTime() / 1000L + " seconds" + Helper.cr());
                log.write(indentationString + "MEAN TEST COUNT:            " + this.testAverages.get(index) + Helper.cr());
                log.write(indentationString + "MAX TEST COUNT:                " + this.testMaxs.get(index) + Helper.cr());
                log.write(indentationString + "MIN TEST COUNT:                " + this.testMins.get(index) + Helper.cr());
                log.write(indentationString + "TEST % STANDARD DEVIATION:        " + this.testStandardDeviations.get(index) + Helper.cr());
                if (index <= 0) continue;
                log.write(indentationString + "% DIFFERENCE:                " + this.percentageDifferences.get(index - 1) + Helper.cr());
                log.write(indentationString + "% DIFFERENCE ALLOWABLE:            " + test.getAllowableDecrease() + Helper.cr());
            }
            if (this.getTestCase() instanceof PerformanceRegressionTest) {
                log.write(indentationString + "BASELINE VERSION:            " + this.getBaselineVersion() + Helper.cr());
                log.write(indentationString + "BASELINE VERSION RESULTS:        " + this.getBaselineVersionResults() + Helper.cr());
                log.write(indentationString + "BASELINE VERSION % STANDARD DEVIATION:    " + this.baselineStandardDeviation + Helper.cr());
                log.write(indentationString + "CURRENT VERSION RESULTS:        " + this.getCurrentVersionResults() + Helper.cr());
                log.write(indentationString + "CURRENT VERSION % STANDARD DEVIATION:    " + this.currentStandardDeviation + Helper.cr());
                log.write(indentationString + "% DIFFERENCE (last run):        " + this.getPercentageDifferenceLastRun() + Helper.cr());
                log.write(indentationString + "% DIFFERENCE (average):            " + this.getPercentageDifferenceAverage() + Helper.cr());
            }
            log.write(Helper.cr() + indentationString + "RESULT:                      " + this.getOutcome() + Helper.cr());
        }
        catch (IOException iOException) {
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        try {
            if (this.getException() != null) {
                this.getException().setIndentationString(indentationString);
                log.write(this.getException() + Helper.cr());
            }
            log.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        LoadBuildSystem.loadBuild.addResult(this);
    }

    public static Number maxResults(List times) {
        Number testMax = new Double(0.0);
        for (int index = 0; index < times.size(); ++index) {
            Number time = (Number)times.get(index);
            if (!(time.doubleValue() > testMax)) continue;
            testMax = time;
        }
        return testMax;
    }

    public static Number minResults(List times) {
        Number testMin = new Double(0.0);
        for (int index = 0; index < times.size(); ++index) {
            Number time = (Number)times.get(index);
            if (testMin.doubleValue() != 0.0 && !(time.doubleValue() < testMin.doubleValue())) continue;
            testMin = time;
        }
        return testMin;
    }

    public static List filterMaxMinResults(List times) {
        ArrayList filteredTimes = new ArrayList(times);
        if (filteredTimes.size() > 3) {
            filteredTimes.remove(PerformanceComparisonTestResult.maxResults(times));
            filteredTimes.remove(PerformanceComparisonTestResult.minResults(times));
        }
        return filteredTimes;
    }

    public static double averageResults(List allTimes) {
        List times = PerformanceComparisonTestResult.filterMaxMinResults(allTimes);
        double testAverage = 0.0;
        for (int index = 0; index < times.size(); ++index) {
            double time = ((Number)times.get(index)).doubleValue();
            testAverage += time;
        }
        return testAverage /= (double)times.size();
    }

    public static double standardDeviationResults(List allTimes) {
        double testAverage = PerformanceComparisonTestResult.averageResults(allTimes);
        List times = PerformanceComparisonTestResult.filterMaxMinResults(allTimes);
        double testStandardDeviation = 0.0;
        for (int index = 0; index < times.size(); ++index) {
            double time = ((Number)times.get(index)).doubleValue();
            testStandardDeviation += Math.pow(time - testAverage, 2.0);
        }
        testStandardDeviation /= (double)times.size();
        testStandardDeviation = Math.sqrt(testStandardDeviation);
        testStandardDeviation = testStandardDeviation / testAverage * 100.0;
        return testStandardDeviation;
    }

    public static double percentageDifference(double result, double baseline) {
        double percentageDifference = (result - baseline) / baseline * 100.0;
        if (percentageDifference < 0.0) {
            percentageDifference = -1.0 * ((baseline - result) / result) * 100.0;
        }
        return percentageDifference;
    }
}

