/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.oracleddl.parser;

import org.eclipse.persistence.tools.oracleddl.parser.DDLParserTreeConstants;
import org.eclipse.persistence.tools.oracleddl.parser.DDLParserVisitor;
import org.eclipse.persistence.tools.oracleddl.parser.Node;
import org.eclipse.persistence.tools.oracleddl.parser.Token;

public class SimpleNode
implements Node {
    protected Node parent;
    protected Node[] children;
    protected int id;
    protected Object value;
    protected Token firstToken;
    protected Token lastToken;

    public SimpleNode(int i) {
        this.id = i;
    }

    @Override
    public void jjtOpen() {
    }

    @Override
    public void jjtClose() {
    }

    @Override
    public void jjtSetParent(Node n) {
        this.parent = n;
    }

    @Override
    public Node jjtGetParent() {
        return this.parent;
    }

    @Override
    public void jjtAddChild(Node n, int i) {
        if (this.children == null) {
            this.children = new Node[i + 1];
        } else if (i >= this.children.length) {
            Node[] c = new Node[i + 1];
            System.arraycopy(this.children, 0, c, 0, this.children.length);
            this.children = c;
        }
        this.children[i] = n;
    }

    @Override
    public Node jjtGetChild(int i) {
        return i < this.jjtGetNumChildren() ? this.children[i] : null;
    }

    @Override
    public int jjtGetNumChildren() {
        return this.children == null ? 0 : this.children.length;
    }

    public void jjtSetValue(Object value) {
        this.value = value;
    }

    public Object jjtGetValue() {
        return this.value;
    }

    public Token jjtGetFirstToken() {
        return this.firstToken;
    }

    public void jjtSetFirstToken(Token token) {
        this.firstToken = token;
    }

    public Token jjtGetLastToken() {
        return this.lastToken;
    }

    public void jjtSetLastToken(Token token) {
        this.lastToken = token;
    }

    @Override
    public Object jjtAccept(DDLParserVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    public Object childrenAccept(DDLParserVisitor visitor, Object data) {
        if (this.children != null) {
            int i = 0;
            while (i < this.children.length) {
                this.children[i].jjtAccept(visitor, data);
                ++i;
            }
        }
        return data;
    }

    public String toString() {
        return DDLParserTreeConstants.jjtNodeName[this.id];
    }

    public String toString(String prefix) {
        return String.valueOf(prefix) + this.toString();
    }

    public void dump(String prefix) {
        System.out.println(this.toString(prefix));
        if (this.children != null) {
            int i = 0;
            while (i < this.children.length) {
                SimpleNode n = (SimpleNode)this.children[i];
                if (n != null) {
                    n.dump(String.valueOf(prefix) + " ");
                }
                ++i;
            }
        }
    }
}

