/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.validation;

import org.eclipse.persistence.descriptors.RelationalDescriptor;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.EclipseLinkException;
import org.eclipse.persistence.internal.descriptors.MethodAttributeAccessor;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.DirectToFieldMapping;
import org.eclipse.persistence.testing.tests.validation.EmployeeWithProblems;
import org.eclipse.persistence.testing.tests.validation.ExceptionTestSaveDescriptor;

public class IllegalAccessWhileGettingValueThruInstanceVariableAccessorTest
extends ExceptionTestSaveDescriptor {
    public IllegalAccessWhileGettingValueThruInstanceVariableAccessorTest() {
        this.setDescription("This tests Access While Getting Value Thru Instance Variable Accessor (TL-ERROR 13)");
    }

    @Override
    protected void setup() {
        this.expectedException = DescriptorException.illegalAccesstWhileGettingValueThruInstanceVaraibleAccessor(null, null, null);
        super.setup();
    }

    @Override
    public void reset() {
        super.reset();
    }

    public void test() {
        EmployeeWithProblems person = new EmployeeWithProblems();
        String address = "Test_data";
        try {
            DatabaseMapping dMapping = this.descriptor().getMappingForAttributeName("illegalAccess");
            ((MethodAttributeAccessor)dMapping.getAttributeAccessor()).initializeAttributes(EmployeeWithProblems.class);
            address = (String)dMapping.getAttributeValueFromObject((Object)person);
        }
        catch (EclipseLinkException exception) {
            this.caughtException = exception;
        }
    }

    public RelationalDescriptor descriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(EmployeeWithProblems.class);
        descriptor.addTableName("EMPLOYEE");
        descriptor.addPrimaryKeyFieldName("EMPLOYEE.EMP_ID");
        descriptor.useSoftCacheWeakIdentityMap();
        descriptor.setIdentityMapSize(100);
        descriptor.useRemoteSoftCacheWeakIdentityMap();
        descriptor.setRemoteIdentityMapSize(100);
        descriptor.setSequenceNumberFieldName("EMP_ID");
        descriptor.setSequenceNumberName("EMP_SEQ");
        descriptor.setAlias("EMPLOYEE");
        descriptor.getQueryManager().checkCacheForDoesExist();
        DirectToFieldMapping p_idMapping = new DirectToFieldMapping();
        p_idMapping.setAttributeName("id");
        p_idMapping.setFieldName("EMPLOYEE.EMP_ID");
        descriptor.addMapping((DatabaseMapping)p_idMapping);
        DirectToFieldMapping p_nameMapping = new DirectToFieldMapping();
        p_nameMapping.setAttributeName("illegalAccess");
        p_nameMapping.setFieldName("EMPLOYEE.F_NAME");
        p_nameMapping.setSetMethodName("setIllegalAccess");
        p_nameMapping.setGetMethodName("getIllegalAccess");
        descriptor.addMapping((DatabaseMapping)p_nameMapping);
        return descriptor;
    }
}

