/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.validation;

import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.RelationalDescriptor;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.EclipseLinkException;
import org.eclipse.persistence.exceptions.IntegrityChecker;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.DirectToFieldMapping;
import org.eclipse.persistence.mappings.OneToOneMapping;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.testing.tests.validation.Address;
import org.eclipse.persistence.testing.tests.validation.Employee;
import org.eclipse.persistence.testing.tests.validation.ExceptionTest;

public class GetMethodReturnsValueHolderTest
extends ExceptionTest {
    public GetMethodReturnsValueHolderTest() {
        this.setDescription("This test contains a descriptor with a mapping that uses indirection, and that mapping's get method returns a ValueHolder instead of a ValueHolderInterface.");
    }

    public RelationalDescriptor descriptor() {
        RelationalDescriptor employeeDescriptor = new RelationalDescriptor();
        employeeDescriptor.setJavaClass(Employee.class);
        employeeDescriptor.setTableName("VAL_EMP");
        employeeDescriptor.setPrimaryKeyFieldName("ID");
        OneToOneMapping addressMapping = new OneToOneMapping();
        addressMapping.setAttributeName("address");
        addressMapping.setReferenceClass(Address.class);
        addressMapping.setSetMethodName("setAddress");
        addressMapping.setGetMethodName("getAddress");
        employeeDescriptor.addMapping((DatabaseMapping)addressMapping);
        return employeeDescriptor;
    }

    protected void setup() {
        this.expectedException = DescriptorException.returnAndMappingWithIndirectionMismatch((DatabaseMapping)new DirectToFieldMapping());
    }

    public void test() {
        try {
            this.getSession().setIntegrityChecker(new IntegrityChecker());
            this.getSession().getIntegrityChecker().dontCatchExceptions();
            ((DatabaseSession)this.getSession()).addDescriptor((ClassDescriptor)this.descriptor());
        }
        catch (EclipseLinkException exception) {
            this.caughtException = exception;
        }
    }
}

