/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.relationshipmaintenance;

import java.util.Iterator;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.relationshipmaintenance.FieldOffice;
import org.eclipse.persistence.testing.models.relationshipmaintenance.SalesPerson;

public class SetReferencedObjectTest
extends AutoVerifyTestCase {
    public FieldOffice fieldOfficeClone;
    public SalesPerson sales = null;
    public SalesPerson secondSales = null;

    public void setup() {
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        this.beginTransaction();
    }

    public void reset() {
        this.rollbackTransaction();
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
    }

    public void test() {
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        Iterator iterator = uow.readAllObjects(SalesPerson.class).iterator();
        this.sales = (SalesPerson)iterator.next();
        this.secondSales = (SalesPerson)iterator.next();
        while (this.secondSales.getFieldOffice() == this.sales.getFieldOffice() && iterator.hasNext()) {
            this.secondSales = (SalesPerson)iterator.next();
        }
        this.fieldOfficeClone = this.sales.getFieldOffice();
        this.sales.setFieldOffice(this.secondSales.getFieldOffice());
    }

    public void verify() {
        if (this.fieldOfficeClone.getSalespeople().contains(this.sales) || this.sales.getFieldOffice() == null || this.secondSales.getFieldOffice() == null || !this.secondSales.getFieldOffice().getSalespeople().contains(this.sales)) {
            throw new TestErrorException("Failed to set the backPointer information");
        }
    }
}

