/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.queries.optimization;

import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.persistence.annotations.BatchFetchType;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.models.aggregate.Employee;

public class AggregateBatchReadingTest
extends TestCase {
    public Vector result;
    BatchFetchType batchType;

    public AggregateBatchReadingTest(BatchFetchType batchType) {
        this.setDescription("Tests batch reading nesting across an aggregate");
        this.batchType = batchType;
        this.setName(this.getName() + batchType);
    }

    public void setup() {
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
    }

    public void test() {
        ReadAllQuery query = new ReadAllQuery();
        query.setReferenceClass(Employee.class);
        query.setBatchFetchType(this.batchType);
        query.addBatchReadAttribute(query.getExpressionBuilder().get("address").get("address"));
        this.result = (Vector)this.getSession().executeQuery((DatabaseQuery)query);
    }

    public void verify() {
        Enumeration employeesEnum = this.result.elements();
        while (employeesEnum.hasMoreElements()) {
            ((Employee)employeesEnum.nextElement()).getAddressDescription().getAddress().getValue();
        }
    }
}

