/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.distributedservers;

import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.internal.sessions.DatabaseSessionImpl;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestSystem;
import org.eclipse.persistence.testing.tests.distributedservers.Company;
import org.eclipse.persistence.testing.tests.distributedservers.Dist_Employee;
import org.eclipse.persistence.testing.tests.distributedservers.DistributedProject;
import org.eclipse.persistence.testing.tests.distributedservers.Item;
import org.eclipse.persistence.tools.schemaframework.DatabaseObjectDefinition;
import org.eclipse.persistence.tools.schemaframework.SchemaManager;

public class DistributedSystem
extends TestSystem {
    public DistributedSystem() {
        this.project = new DistributedProject();
    }

    public void addDescriptors(DatabaseSession session) {
        session.logMessage("Project is from generated code");
        session.addDescriptors(this.project);
    }

    public void createTables(DatabaseSession session) {
        SchemaManager schemaManager = new SchemaManager(session);
        schemaManager.buildFieldTypes(Dist_Employee.tableDefinition());
        schemaManager.buildFieldTypes(Company.tableDefinition());
        schemaManager.buildFieldTypes(Item.tableDefinition());
        try {
            schemaManager.dropConstraints(Dist_Employee.tableDefinition());
            schemaManager.dropConstraints(Company.tableDefinition());
            schemaManager.dropConstraints(Item.tableDefinition());
        }
        catch (DatabaseException databaseException) {
            // empty catch block
        }
        schemaManager.replaceObject((DatabaseObjectDefinition)Dist_Employee.tableDefinition());
        schemaManager.replaceObject((DatabaseObjectDefinition)Company.tableDefinition());
        schemaManager.replaceObject((DatabaseObjectDefinition)Item.tableDefinition());
        schemaManager.createConstraints(Dist_Employee.tableDefinition());
        schemaManager.createConstraints(Company.tableDefinition());
        schemaManager.createConstraints(Item.tableDefinition());
        schemaManager.createSequences();
    }

    public DatabaseSession login() {
        DatabaseSessionImpl session = new DatabaseSessionImpl(this.project);
        session.login();
        return session;
    }

    public void populate(DatabaseSession session) {
        UnitOfWork unitOfWork = session.acquireUnitOfWork();
        unitOfWork.registerObject((Object)Dist_Employee.example1());
        unitOfWork.registerObject((Object)Company.example1());
        unitOfWork.commit();
    }
}

