/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.jpql;

import java.util.List;
import javax.persistence.EntityManager;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.server.ServerSession;
import org.eclipse.persistence.testing.framework.junit.JUnitTestCase;
import org.eclipse.persistence.testing.models.jpa.advanced.AdvancedTableCreator;
import org.eclipse.persistence.testing.models.jpa.advanced.Employee;
import org.eclipse.persistence.testing.models.jpa.advanced.EmployeePopulator;
import org.eclipse.persistence.testing.models.jpa.advanced.Project;
import org.eclipse.persistence.testing.models.jpa.advanced.SmallProject;
import org.eclipse.persistence.testing.models.jpa.inheritance.AAA;
import org.eclipse.persistence.testing.models.jpa.inheritance.Engineer;
import org.eclipse.persistence.testing.models.jpa.inheritance.InheritancePopulator;
import org.eclipse.persistence.testing.models.jpa.inheritance.InheritanceTableCreator;
import org.eclipse.persistence.testing.tests.jpa.jpql.JUnitDomainObjectComparer;
import org.junit.Assert;

public class JUnitJPQLInheritanceTestSuite
extends JUnitTestCase {
    static JUnitDomainObjectComparer comparer;

    public JUnitJPQLInheritanceTestSuite() {
    }

    public JUnitJPQLInheritanceTestSuite(String name) {
        super(name);
    }

    public void tearDown() {
        this.clearCache();
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.setName("JUnitJPQLInheritanceTestSuite");
        suite.addTest((Test)new JUnitJPQLInheritanceTestSuite("testSetup"));
        suite.addTest((Test)new JUnitJPQLInheritanceTestSuite("testStraightReadSuperClass"));
        suite.addTest((Test)new JUnitJPQLInheritanceTestSuite("testStraightReadSubClass"));
        suite.addTest((Test)new JUnitJPQLInheritanceTestSuite("testJoinSuperClass"));
        suite.addTest((Test)new JUnitJPQLInheritanceTestSuite("testJoinSubClass"));
        suite.addTest((Test)new JUnitJPQLInheritanceTestSuite("testJoinFetchSuperClass"));
        suite.addTest((Test)new JUnitJPQLInheritanceTestSuite("testJoinFetchSubClass"));
        suite.addTest((Test)new JUnitJPQLInheritanceTestSuite("testJoinedInheritance"));
        suite.addTest((Test)new JUnitJPQLInheritanceTestSuite("testJoinedInheritanceWithLeftOuterJoin1"));
        suite.addTest((Test)new JUnitJPQLInheritanceTestSuite("testJoinedInheritanceWithLeftOuterJoin2"));
        suite.addTest((Test)new JUnitJPQLInheritanceTestSuite("testJoinedInheritanceWithLeftOuterJoin3"));
        suite.addTest((Test)new JUnitJPQLInheritanceTestSuite("testComputer"));
        suite.addTest((Test)new JUnitJPQLInheritanceTestSuite("testAllPeople"));
        suite.addTest((Test)new JUnitJPQLInheritanceTestSuite("testConverter"));
        return suite;
    }

    public void testSetup() {
        this.clearCache();
        ServerSession session = JUnitTestCase.getServerSession();
        EmployeePopulator employeePopulator = new EmployeePopulator();
        comparer = new JUnitDomainObjectComparer();
        comparer.setSession((AbstractSession)session.getActiveSession());
        new AdvancedTableCreator().replaceTables((DatabaseSession)session);
        new InheritanceTableCreator().replaceTables((DatabaseSession)session);
        employeePopulator.buildExamples();
        employeePopulator.persistExample((Session)session);
        InheritancePopulator inheritancePopulator = new InheritancePopulator();
        inheritancePopulator.buildExamples();
        inheritancePopulator.persistExample((Session)session);
    }

    public void testStraightReadSuperClass() {
        EntityManager em = this.createEntityManager();
        Project project = (Project)em.createQuery("SELECT p from Project p").getResultList().get(0);
        this.clearCache();
        ReadObjectQuery tlQuery = new ReadObjectQuery(Project.class);
        tlQuery.setSelectionCriteria(tlQuery.getExpressionBuilder().get("id").equal((Object)project.getId()));
        Project tlProject = (Project)JUnitJPQLInheritanceTestSuite.getServerSession().executeQuery((DatabaseQuery)tlQuery);
        Assert.assertTrue((String)"SuperClass Inheritance Test Failed", (boolean)comparer.compareObjects((Object)project, tlProject));
    }

    public void testStraightReadSubClass() {
        EntityManager em = this.createEntityManager();
        SmallProject project = (SmallProject)em.createQuery("SELECT s from SmallProject s").getResultList().get(0);
        this.clearCache();
        ReadObjectQuery tlQuery = new ReadObjectQuery(SmallProject.class);
        tlQuery.setSelectionCriteria(tlQuery.getExpressionBuilder().get("id").equal((Object)project.getId()));
        SmallProject tlProject = (SmallProject)JUnitJPQLInheritanceTestSuite.getServerSession().executeQuery((DatabaseQuery)tlQuery);
        Assert.assertTrue((String)"Subclass Inheritance Test Failed", (boolean)comparer.compareObjects((Object)project, tlProject));
    }

    public void testJoinSuperClass() {
        EntityManager em = this.createEntityManager();
        Employee emp = (Employee)em.createQuery("SELECT e from Employee e JOIN e.projects p where e.lastName is not null").getResultList().get(0);
        this.clearCache();
        ReadObjectQuery tlQuery = new ReadObjectQuery(Employee.class);
        tlQuery.setSelectionCriteria(tlQuery.getExpressionBuilder().get("id").equal((Object)emp.getId()));
        tlQuery.addJoinedAttribute(tlQuery.getExpressionBuilder().anyOf("projects"));
        Employee tlEmp = (Employee)JUnitJPQLInheritanceTestSuite.getServerSession().executeQuery((DatabaseQuery)tlQuery);
        Assert.assertTrue((String)"Join superclass Inheritance Test Failed", (boolean)comparer.compareObjects((Object)emp, tlEmp));
    }

    public void testJoinSubClass() {
        EntityManager em = this.createEntityManager();
        Engineer emp = (Engineer)em.createQuery("SELECT e from Engineer e JOIN e.bestFriend b WHERE e.title is not null").getResultList().get(0);
        this.clearCache();
        ReadObjectQuery tlQuery = new ReadObjectQuery(Engineer.class);
        tlQuery.setSelectionCriteria(tlQuery.getExpressionBuilder().get("id").equal((Object)emp.getId()));
        tlQuery.addJoinedAttribute(tlQuery.getExpressionBuilder().get("bestFriend"));
        Engineer tlEmp = (Engineer)JUnitJPQLInheritanceTestSuite.getServerSession().executeQuery((DatabaseQuery)tlQuery);
        Assert.assertTrue((String)"Join Subclass Inheritance Test Failed", (boolean)comparer.compareObjects((Object)emp, tlEmp));
    }

    public void testJoinFetchSuperClass() {
        EntityManager em = this.createEntityManager();
        Employee emp = (Employee)em.createQuery("SELECT e from Employee e JOIN FETCH e.projects").getResultList().get(0);
        this.clearCache();
        ReadObjectQuery tlQuery = new ReadObjectQuery(Employee.class);
        tlQuery.setSelectionCriteria(tlQuery.getExpressionBuilder().get("id").equal((Object)emp.getId()));
        tlQuery.addJoinedAttribute(tlQuery.getExpressionBuilder().anyOf("projects"));
        Employee tlEmp = (Employee)JUnitJPQLInheritanceTestSuite.getServerSession().executeQuery((DatabaseQuery)tlQuery);
        Assert.assertTrue((String)"Join superclass Inheritance Test Failed", (boolean)comparer.compareObjects((Object)emp, tlEmp));
    }

    public void testJoinFetchSubClass() {
        EntityManager em = this.createEntityManager();
        Engineer emp = (Engineer)em.createQuery("SELECT e from Engineer e JOIN FETCH e.bestFriend").getResultList().get(0);
        this.clearCache();
        ReadObjectQuery tlQuery = new ReadObjectQuery(Engineer.class);
        tlQuery.setSelectionCriteria(tlQuery.getExpressionBuilder().get("id").equal((Object)emp.getId()));
        tlQuery.addJoinedAttribute(tlQuery.getExpressionBuilder().get("bestFriend"));
        Engineer tlEmp = (Engineer)JUnitJPQLInheritanceTestSuite.getServerSession().executeQuery((DatabaseQuery)tlQuery);
        Assert.assertTrue((String)"Join Subclass Inheritance Test Failed", (boolean)comparer.compareObjects((Object)emp, tlEmp));
    }

    public void testJoinedInheritance() {
        EntityManager em = this.createEntityManager();
        String ejbqlString = "SELECT OBJECT(b) FROM BBB b WHERE b.foo = ?1";
        em.createQuery(ejbqlString).setParameter(1, (Object)"bar").getSingleResult();
    }

    public void testJoinedInheritanceWithLeftOuterJoin1() {
        EntityManager em = this.createEntityManager();
        String ejbqlString = "SELECT t0.maxSpeed, t0.color, t0.description, t0.fuelCapacity, t0.fuelType, t0.id, t0.passengerCapacity, t1.name, t1.id FROM SportsCar t0 LEFT OUTER JOIN t0.owner t1";
        try {
            em.createQuery(ejbqlString).getResultList();
        }
        catch (Exception e) {
            JUnitJPQLInheritanceTestSuite.fail((String)("Error occurred on a left outer join sql expression on a joined inheritance test: " + e.getCause()));
        }
    }

    public void testJoinedInheritanceWithLeftOuterJoin2() {
        EntityManager em = this.createEntityManager();
        String ejbqlString = "SELECT t0.color, t0.description, t0.fuelCapacity, t0.fuelType, t0.id, t0.passengerCapacity, t1.name, t1.id FROM FueledVehicle t0 LEFT OUTER JOIN t0.owner t1";
        try {
            em.createQuery(ejbqlString).getResultList();
        }
        catch (Exception e) {
            JUnitJPQLInheritanceTestSuite.fail((String)("Error occurred on a left outer join sql expression on a joined inheritance test: " + e.getCause()));
        }
    }

    public void testJoinedInheritanceWithLeftOuterJoin3() {
        EntityManager em = this.createEntityManager();
        String ejbqlString = "SELECT t0.color, t0.description, t0.fuelCapacity, t0.fuelType, t0.id, t0.passengerCapacity, t1.name, t1.id FROM Bus t0 LEFT OUTER JOIN t0.busDriver t1";
        try {
            em.createQuery(ejbqlString).getResultList();
        }
        catch (Exception e) {
            JUnitJPQLInheritanceTestSuite.fail((String)("Error occurred on a left outer join sql expression on a joined inheritance test: " + e.getCause()));
        }
    }

    public void testComputer() {
        String ejbqlString;
        EntityManager em = this.createEntityManager();
        List result = em.createQuery(ejbqlString = "SELECT c FROM Computer c").getResultList();
        if (result.size() != 4) {
            JUnitJPQLInheritanceTestSuite.fail((String)("Expected 4 computers got: " + result));
        }
    }

    public void testAllPeople() {
        String ejbqlString;
        EntityManager em = this.createEntityManager();
        List result = em.createQuery(ejbqlString = "SELECT p FROM Person p order by p.id").getResultList();
        if (result.size() != 8) {
            JUnitJPQLInheritanceTestSuite.fail((String)("Expected 8 people got: " + result));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testConverter() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            AAA aaa = new AAA();
            em.persist((Object)aaa);
            aaa = new AAA();
            em.persist((Object)aaa);
            em.flush();
            String ejbqlString = "SELECT MAX(aaa.id) FROM AAA aaa";
            Object result = em.createQuery(ejbqlString).getSingleResult();
            Assert.assertEquals((String)"Converter not applied", String.class, result.getClass());
        }
        finally {
            this.rollbackTransaction(em);
        }
    }

    public static boolean equals(Object o1, Object o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        return o1.equals(o2);
    }
}

