/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.transactions;

import org.eclipse.persistence.sessions.SessionEvent;
import org.eclipse.persistence.sessions.SessionEventAdapter;
import org.eclipse.persistence.sessions.SessionEventListener;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;

public class EmptyTransactionTest
extends AutoVerifyTestCase {
    protected boolean transactionOccurred = false;
    private SessionEventAdapter eventAdapter = new SessionEventAdapter(){

        public void preBeginTransaction(SessionEvent event) {
            EmptyTransactionTest.this.transactionOccurred(event);
        }

        public void postBeginTransaction(SessionEvent event) {
            EmptyTransactionTest.this.transactionOccurred(event);
        }
    };

    public void transactionOccurred(SessionEvent event) {
        this.transactionOccurred = true;
    }

    public void setup() {
        this.getSession().getEventManager().addListener((SessionEventListener)this.eventAdapter);
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
    }

    public void test() {
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        uow.commit();
    }

    public void verify() {
        if (this.transactionOccurred) {
            throw new TestErrorException("A transaction was started in the UnitOfWork even though there were no changes.");
        }
    }

    public void reset() {
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
        this.getSession().getEventManager().removeListener((SessionEventListener)this.eventAdapter);
    }
}

