/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.performance;

import java.sql.Date;
import junit.framework.Test;
import org.eclipse.persistence.Version;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.server.Server;
import org.eclipse.persistence.testing.framework.TestModel;
import org.eclipse.persistence.testing.models.interfaces.InterfaceHashtableProject;
import org.eclipse.persistence.testing.models.performance.Address;
import org.eclipse.persistence.testing.models.performance.EmploymentPeriod;
import org.eclipse.persistence.testing.models.performance.toplink.Employee;
import org.eclipse.persistence.testing.models.performance.toplink.EmployeeSystem;
import org.eclipse.persistence.testing.models.performance.toplink.PhoneNumber;
import org.eclipse.persistence.testing.tests.performance.concurrent.AddPhoneCachedConcurrentRegressionTest;
import org.eclipse.persistence.testing.tests.performance.concurrent.ReadAllObjectsConcurrentRegressionTest;
import org.eclipse.persistence.testing.tests.performance.concurrent.ReadAllUOWConcurrentRegressionTest;
import org.eclipse.persistence.testing.tests.performance.concurrent.ReadAnyObjectCachedConcurrentRegressionTest;
import org.eclipse.persistence.testing.tests.performance.concurrent.ReadAnyObjectIsolatedConcurrentRegressionTest;
import org.eclipse.persistence.testing.tests.performance.concurrent.ReadObjectCachedConcurrentRegressionTest;
import org.eclipse.persistence.testing.tests.performance.concurrent.ReadObjectCachedUOWConcurrentRegressionTest;
import org.eclipse.persistence.testing.tests.performance.concurrent.UpdateAnyObjectCachedConcurrentRegressionTest;

public class ConcurrencyRegressionTestModel
extends TestModel {
    protected Session oldSession;

    public ConcurrencyRegressionTestModel() {
        this.setDescription("Multi-CPU concurrency tests.");
    }

    public void addRequiredSystems() {
        this.addRequiredSystem(new EmployeeSystem());
    }

    public void addTests() {
        this.addTest((Test)new ReadObjectCachedConcurrentRegressionTest());
        this.addTest((Test)new ReadAnyObjectCachedConcurrentRegressionTest());
        this.addTest((Test)new ReadAnyObjectIsolatedConcurrentRegressionTest());
        this.addTest((Test)new ReadObjectCachedUOWConcurrentRegressionTest());
        this.addTest((Test)new ReadAllObjectsConcurrentRegressionTest());
        this.addTest((Test)new ReadAllUOWConcurrentRegressionTest());
        this.addTest((Test)new AddPhoneCachedConcurrentRegressionTest());
        this.addTest((Test)new UpdateAnyObjectCachedConcurrentRegressionTest());
    }

    public void setup() {
        for (int j = 0; j < 100; ++j) {
            Employee empInsert = new Employee();
            empInsert.setFirstName("Brendan");
            empInsert.setMale();
            empInsert.setLastName("" + j + "");
            empInsert.setSalary(100000);
            EmploymentPeriod employmentPeriod = new EmploymentPeriod();
            Date startDate = Helper.dateFromString((String)"1901-12-31");
            Date endDate = Helper.dateFromString((String)"1895-01-01");
            employmentPeriod.setEndDate(endDate);
            employmentPeriod.setStartDate(startDate);
            empInsert.setPeriod(employmentPeriod);
            empInsert.setAddress(new Address());
            empInsert.getAddress().setCity("Nepean");
            empInsert.getAddress().setPostalCode("N5J2N5");
            empInsert.getAddress().setProvince("ON");
            empInsert.getAddress().setStreet("1111 Mountain Blvd. Floor 13, suite " + j);
            empInsert.getAddress().setCountry("Canada");
            empInsert.addPhoneNumber(new PhoneNumber("Work Fax", "613", "2255943"));
            empInsert.addPhoneNumber(new PhoneNumber("Home", "613", "2224599"));
            this.getDatabaseSession().insertObject((Object)empInsert);
        }
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
        this.oldSession = this.getSession();
        Server serverSession = this.getSession().getProject().createServerSession(32, 32);
        serverSession.useExclusiveReadConnectionPool(32, 32);
        if (Version.getVersion().indexOf("10.1.3") != -1) {
            serverSession.getLogin().setShouldBindAllParameters(true);
        }
        serverSession.getLogin().setShouldCacheAllStatements(true);
        serverSession.addDescriptors((Project)new InterfaceHashtableProject());
        serverSession.setSessionLog(this.getSession().getSessionLog());
        serverSession.login();
        this.getExecutor().setSession((Session)serverSession);
    }

    public void reset() {
        if (this.oldSession != null) {
            this.getDatabaseSession().logout();
            this.getExecutor().setSession(this.oldSession);
        }
    }
}

