/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.unitofwork.changeflag;

import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TransactionalTestCase;
import org.eclipse.persistence.testing.models.relationshipmaintenance.FieldOffice;
import org.eclipse.persistence.testing.models.relationshipmaintenance.SalesPerson;

public class TransparentIndirectionResumeAddTest
extends TransactionalTestCase {
    public TransparentIndirectionResumeAddTest() {
        this.setDescription("Test adding to indirect collections on new objects after a commit and resume.");
    }

    public void test() {
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        FieldOffice office = new FieldOffice();
        SalesPerson person = new SalesPerson();
        person.setName("Bob");
        person.setFieldOffice(office);
        office.getSalespeople().add(person);
        uow.registerNewObject((Object)office);
        uow.commitAndResume();
        person = new SalesPerson();
        person.setName("Joe");
        person.setFieldOffice(office);
        office.getSalespeople().add(person);
        if (!office.getSalespeople().contains(person)) {
            this.throwError("Person not added in clone.");
        }
        uow.commit();
        office = (FieldOffice)this.getSession().readObject((Object)office);
        person = (SalesPerson)this.getSession().readObject((Object)person);
        if (!office.getSalespeople().contains(person)) {
            this.throwError("Person not added in cache.");
        }
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        office = (FieldOffice)this.getSession().readObject((Object)office);
        person = (SalesPerson)this.getSession().readObject((Object)person);
        if (!office.getSalespeople().contains(person)) {
            this.throwError("Person not added in cache.");
        }
    }
}

