/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.performance.writing;

import javax.persistence.EntityManager;
import org.eclipse.persistence.testing.framework.PerformanceRegressionTestCase;
import org.eclipse.persistence.testing.models.jpa.performance2.Degree;
import org.eclipse.persistence.testing.models.jpa.performance2.Employee;
import org.eclipse.persistence.testing.models.jpa.performance2.PhoneNumber;

public class JPA2ComplexUpdateEmployeePerformanceComparisonTest
extends PerformanceRegressionTestCase {
    protected Employee originalEmployee;
    protected long count;

    public JPA2ComplexUpdateEmployeePerformanceComparisonTest() {
        this.setDescription("This test compares the performance of update Employee.");
    }

    public void setup() {
        EntityManager manager = this.createEntityManager();
        this.originalEmployee = (Employee)manager.createQuery("Select e from Employee e").getResultList().get(0);
        this.originalEmployee.getAddress().getCity();
        this.originalEmployee.getPhoneNumbers().size();
        this.count = 0L;
        manager.close();
    }

    public void test() throws Exception {
        EntityManager manager = this.createEntityManager();
        manager.getTransaction().begin();
        Employee employee = (Employee)manager.find(Employee.class, (Object)this.originalEmployee.getId());
        ++this.count;
        employee.setFirstName(this.originalEmployee.getFirstName() + this.count);
        employee.setLastName(this.originalEmployee.getLastName() + this.count);
        employee.getAddress().setStreet(this.originalEmployee.getAddress().getStreet() + this.count);
        employee.getAddress().setCity(this.originalEmployee.getAddress().getCity() + this.count);
        employee.getAddress().setCity(this.originalEmployee.getAddress().getCity() + this.count);
        try {
            PhoneNumber workFax = null;
            for (PhoneNumber phone : employee.getPhoneNumbers()) {
                if (!phone.getType().equals("work-fax")) continue;
                workFax = phone;
                break;
            }
            if (workFax == null) {
                PhoneNumber phone = new PhoneNumber();
                phone.setType("work-fax");
                phone.setAreaCode("613");
                phone.setNumber("9991111");
                employee.addPhoneNumber(phone);
            } else {
                employee.removePhoneNumber(workFax);
            }
            Degree bComp = null;
            for (Degree degree : employee.getDegrees()) {
                if (!degree.getName().equals("BComp")) continue;
                bComp = degree;
                break;
            }
            if (bComp == null) {
                employee.addDegree("BComp");
            } else {
                employee.removeDegree(bComp);
            }
            if (employee.getEmailAddresses().containsKey("work")) {
                employee.removeEmailAddress("work");
            } else {
                employee.addEmailAddress("work", "joe@acme.com");
            }
            if (employee.getResponsibilities().contains("write code")) {
                employee.removeResponsibility("write code");
            } else {
                employee.addResponsibility("write code");
            }
            manager.getTransaction().commit();
        }
        catch (Exception exception) {
            employee = (Employee)manager.getReference(Employee.class, (Object)this.originalEmployee.getId());
            manager.refresh((Object)employee);
            employee.getPhoneNumbers();
        }
        manager.close();
    }
}

