/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.jpaadvancedproperties;

import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.jpa.JpaEntityManager;
import org.eclipse.persistence.logging.JavaLog;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.server.ServerSession;
import org.eclipse.persistence.testing.framework.junit.JUnitTestCase;
import org.eclipse.persistence.testing.models.jpa.jpaadvancedproperties.Customer;
import org.eclipse.persistence.testing.models.jpa.jpaadvancedproperties.JPAPropertiesRelationshipTableManager;
import org.eclipse.persistence.testing.models.jpa.jpaadvancedproperties.ModelExamples;
import org.eclipse.persistence.testing.models.jpa.jpaadvancedproperties.Order;
import org.eclipse.persistence.testing.tests.jpa.jpaadvancedproperties.CustomizedEncryptor;
import org.eclipse.persistence.testing.tests.jpa.jpaadvancedproperties.CustomizedSessionEventListener;
import org.eclipse.persistence.tools.profiler.PerformanceProfiler;

public class JPAAdvPropertiesJUnitTestCase
extends JUnitTestCase {
    private static String persistenceUnitName = "JPAADVProperties";

    public JPAAdvPropertiesJUnitTestCase() {
    }

    public JPAAdvPropertiesJUnitTestCase(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("JPA Advanced Properties Model");
        suite.addTest((Test)new JPAAdvPropertiesJUnitTestCase("testSetup"));
        suite.addTest((Test)new JPAAdvPropertiesJUnitTestCase("testSessionXMLProperty"));
        suite.addTest((Test)new JPAAdvPropertiesJUnitTestCase("testSessionEventListenerProperty"));
        suite.addTest((Test)new JPAAdvPropertiesJUnitTestCase("testExceptionHandlerProperty"));
        suite.addTest((Test)new JPAAdvPropertiesJUnitTestCase("testNativeSQLProperty"));
        suite.addTest((Test)new JPAAdvPropertiesJUnitTestCase("testCacheStatementsAndItsSizeProperty"));
        suite.addTest((Test)new JPAAdvPropertiesJUnitTestCase("testBatchwritingProperty"));
        suite.addTest((Test)new JPAAdvPropertiesJUnitTestCase("testCopyDescriptorNamedQueryToSessionProperty"));
        suite.addTest((Test)new JPAAdvPropertiesJUnitTestCase("testLoggingTyperProperty"));
        suite.addTest((Test)new JPAAdvPropertiesJUnitTestCase("testProfilerTyperProperty"));
        suite.addTest((Test)new JPAAdvPropertiesJUnitTestCase("testLoginEncryptorProperty"));
        return suite;
    }

    public void testSetup() {
        new JPAPropertiesRelationshipTableManager().replaceTables((DatabaseSession)JUnitTestCase.getServerSession((String)persistenceUnitName));
        this.clearCache();
    }

    public void testSessionEventListenerProperty() {
        EntityManager em = JPAAdvPropertiesJUnitTestCase.createEntityManager((String)persistenceUnitName);
        ServerSession session = null;
        session = JPAAdvPropertiesJUnitTestCase.isOnServer() ? JPAAdvPropertiesJUnitTestCase.getServerSession() : ((JpaEntityManager)em.getDelegate()).getServerSession();
        try {
            this.beginTransaction(em);
            Customer customer = ModelExamples.customerExample1();
            em.persist((Object)customer);
            em.flush();
            Integer customerId = customer.getCustomerId();
            this.commitTransaction(em);
            this.beginTransaction(em);
            em.remove(em.find(Customer.class, (Object)customerId));
            this.commitTransaction(em);
            List listeners = session.getEventManager().getListeners();
            boolean doseCustomizedSessionEventListenerExists = false;
            for (int i = 0; i < listeners.size(); ++i) {
                Object aListener = listeners.get(i);
                if (!(aListener instanceof CustomizedSessionEventListener)) continue;
                doseCustomizedSessionEventListenerExists = true;
                CustomizedSessionEventListener requiredListener = (CustomizedSessionEventListener)((Object)aListener);
                if (!requiredListener.preCommitTransaction) {
                    JPAAdvPropertiesJUnitTestCase.fail((String)" The preCommitTransaction event did not fire");
                }
                if (!requiredListener.postCommitTransaction) {
                    JPAAdvPropertiesJUnitTestCase.fail((String)"The postCommitTransaction event did not fire");
                }
                if (!requiredListener.preBeginTransaction) {
                    JPAAdvPropertiesJUnitTestCase.fail((String)"The preBeginTransaction event did not fire");
                }
                if (!requiredListener.postBeginTransaction) {
                    JPAAdvPropertiesJUnitTestCase.fail((String)"The postBeginTransaction event did not fire");
                }
                if (!requiredListener.postLogin) {
                    JPAAdvPropertiesJUnitTestCase.fail((String)"The postlogin event did not fire");
                }
                if (requiredListener.preLogin) continue;
                JPAAdvPropertiesJUnitTestCase.fail((String)"The preLogin event did not fire");
            }
            if (!doseCustomizedSessionEventListenerExists) {
                JPAAdvPropertiesJUnitTestCase.fail((String)"The session event listener specified by the property eclipselink.session-event-listener in persistence.xml not be processed properly.");
            }
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            throw e;
        }
        finally {
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testExceptionHandlerProperty() {
        EntityManager em = JPAAdvPropertiesJUnitTestCase.createEntityManager((String)persistenceUnitName);
        ServerSession session = null;
        session = JPAAdvPropertiesJUnitTestCase.isOnServer() ? JPAAdvPropertiesJUnitTestCase.getServerSession() : ((JpaEntityManager)em.getDelegate()).getServerSession();
        Expression exp = new ExpressionBuilder().get("name1").equal((Object)"George W.");
        try {
            Object result = session.readObject(Customer.class, exp);
            if (!((String)result).equals("return from CustomizedExceptionHandler")) {
                JPAAdvPropertiesJUnitTestCase.fail((String)"The exception handler specified by the property eclipselink.exception-handler in persistence.xml not be processed.");
            }
        }
        finally {
            this.closeEntityManager(em);
        }
    }

    public void testNativeSQLProperty() {
        EntityManager em = JPAAdvPropertiesJUnitTestCase.createEntityManager((String)persistenceUnitName);
        ServerSession session = null;
        session = JPAAdvPropertiesJUnitTestCase.isOnServer() ? JPAAdvPropertiesJUnitTestCase.getServerSession() : ((JpaEntityManager)em.getDelegate()).getServerSession();
        if (!session.getProject().getLogin().shouldUseNativeSQL()) {
            JPAAdvPropertiesJUnitTestCase.fail((String)"The native sql flag specified as true by the property eclipselink.jdbc.native-sql in persistence.xml, it however read as false.");
        }
        this.closeEntityManager(em);
    }

    public void testBatchwritingProperty() {
        EntityManager em = JPAAdvPropertiesJUnitTestCase.createEntityManager((String)persistenceUnitName);
        ServerSession session = null;
        session = JPAAdvPropertiesJUnitTestCase.isOnServer() ? JPAAdvPropertiesJUnitTestCase.getServerSession() : ((JpaEntityManager)em.getDelegate()).getServerSession();
        if (!session.getPlatform().usesBatchWriting() || session.getPlatform().usesJDBCBatchWriting() || session.getPlatform().usesNativeBatchWriting()) {
            JPAAdvPropertiesJUnitTestCase.fail((String)"The BatcheWriting setting set to BUFFERED by the property eclipselink.jdbc.batch-writing in persistence.xml, JDBC batch writing or native batch writing however may be wrong.");
        }
        this.closeEntityManager(em);
    }

    public void testCopyDescriptorNamedQueryToSessionProperty() {
        EntityManager em = JPAAdvPropertiesJUnitTestCase.createEntityManager((String)persistenceUnitName);
        ServerSession session = null;
        session = JPAAdvPropertiesJUnitTestCase.isOnServer() ? JPAAdvPropertiesJUnitTestCase.getServerSession() : ((JpaEntityManager)em.getDelegate()).getServerSession();
        DatabaseQuery query = session.getQuery("customerReadByName");
        if (query == null) {
            JPAAdvPropertiesJUnitTestCase.fail((String)"The copy descriptor named query is enable by the property eclipselink.session.include.descriptor.queries in persistence.xml, one descriptor named query has not been copied to the session");
        }
        this.closeEntityManager(em);
    }

    public void testCacheStatementsAndItsSizeProperty() {
        EntityManager em = JPAAdvPropertiesJUnitTestCase.createEntityManager((String)persistenceUnitName);
        ServerSession session = null;
        session = JPAAdvPropertiesJUnitTestCase.isOnServer() ? JPAAdvPropertiesJUnitTestCase.getServerSession() : ((JpaEntityManager)em.getDelegate()).getServerSession();
        if (session.getConnectionPools().size() > 0 && !session.getProject().getLogin().shouldCacheAllStatements()) {
            JPAAdvPropertiesJUnitTestCase.fail((String)"Caching all statements flag set equals to true by property eclipselink.jdbc.cache-statements in persistence.xml, it however read as false.");
        }
        if (session.getProject().getLogin().getStatementCacheSize() != 100) {
            JPAAdvPropertiesJUnitTestCase.fail((String)"Statiment cache size set to 100 by property eclipselink.jdbc.cache-statements in persistence.xml, it however read as wrong size.");
        }
        this.closeEntityManager(em);
    }

    public void testLoggingTyperProperty() {
        EntityManager em = JPAAdvPropertiesJUnitTestCase.createEntityManager((String)persistenceUnitName);
        ServerSession session = null;
        session = JPAAdvPropertiesJUnitTestCase.isOnServer() ? JPAAdvPropertiesJUnitTestCase.getServerSession() : ((JpaEntityManager)em.getDelegate()).getServerSession();
        if (!(session.getSessionLog() instanceof JavaLog)) {
            JPAAdvPropertiesJUnitTestCase.fail((String)"Logging type set to JavaLog, it however has been detected as different type logger.");
        }
        this.closeEntityManager(em);
    }

    public void testProfilerTyperProperty() {
        if (JPAAdvPropertiesJUnitTestCase.isOnServer()) {
            return;
        }
        EntityManager em = JPAAdvPropertiesJUnitTestCase.createEntityManager((String)"JPAADVProperties2");
        ServerSession session = ((JpaEntityManager)em.getDelegate()).getServerSession();
        if (!(session.getProfiler() instanceof PerformanceProfiler)) {
            JPAAdvPropertiesJUnitTestCase.fail((String)"Profiler type set to PerformanceProfiler, it however has been detected as different type Profiler.");
        }
        this.closeEntityManager(em);
        em = JPAAdvPropertiesJUnitTestCase.createEntityManager((String)"JPAADVProperties3");
        session = ((JpaEntityManager)em.getDelegate()).getServerSession();
        if (session.getProfiler() != null) {
            JPAAdvPropertiesJUnitTestCase.fail((String)"no profiler has been set,it however has been detected.");
        }
        this.closeEntityManager(em);
    }

    public void testSessionXMLProperty() {
        Integer customerId;
        AbstractList orders;
        EntityManager em = JPAAdvPropertiesJUnitTestCase.createEntityManager((String)persistenceUnitName);
        this.beginTransaction(em);
        try {
            Customer customer = ModelExamples.customerExample1();
            orders = new ArrayList<Order>();
            orders.add(ModelExamples.orderExample1());
            orders.add(ModelExamples.orderExample2());
            orders.add(ModelExamples.orderExample3());
            customer.setOrders(orders);
            em.persist((Object)customer);
            em.flush();
            customerId = customer.getCustomerId();
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
        this.beginTransaction(em);
        try {
            Customer cm1 = (Customer)em.find(Customer.class, (Object)customerId);
            if (cm1 == null) {
                JPAAdvPropertiesJUnitTestCase.fail((String)"Error finding customer ");
            }
            orders = null;
            orders = JPAAdvPropertiesJUnitTestCase.isOnServer() ? (Vector)cm1.getOrders() : (ArrayList)cm1.getOrders();
            if (orders == null || ((AbstractCollection)orders).size() != 3) {
                JPAAdvPropertiesJUnitTestCase.fail((String)"Error finding order pertaining to the customer ");
            }
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
        Customer cm2 = null;
        this.beginTransaction(em);
        try {
            Query query = JPAAdvPropertiesJUnitTestCase.createEntityManager((String)persistenceUnitName).createNamedQuery("customerReadByName");
            query.setParameter("name", (Object)"George W.");
            cm2 = (Customer)query.getSingleResult();
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
        JPAAdvPropertiesJUnitTestCase.assertTrue((String)"Error executing named query 'customerReadByName'", (cm2 != null ? 1 : 0) != 0);
        this.beginTransaction(em);
        String originalName = null;
        try {
            Customer cm = (Customer)em.find(Customer.class, (Object)customerId);
            originalName = cm.getName();
            cm.setName(originalName + "-modified");
            em.merge((Object)cm);
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
        this.clearCache();
        Customer cm3 = (Customer)em.find(Customer.class, (Object)customerId);
        JPAAdvPropertiesJUnitTestCase.assertTrue((String)"Error updating Customer", (boolean)cm3.getName().equals(originalName + "-modified"));
        this.beginTransaction(em);
        try {
            em.remove(em.find(Customer.class, (Object)customerId));
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
        JPAAdvPropertiesJUnitTestCase.assertTrue((String)"Error deleting Customer", (em.find(Customer.class, (Object)customerId) == null ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLoginEncryptorProperty() {
        EntityManager em = JPAAdvPropertiesJUnitTestCase.createEntityManager((String)persistenceUnitName);
        try {
            this.beginTransaction(em);
            Customer customer = ModelExamples.customerExample1();
            em.persist((Object)customer);
            em.flush();
            Integer customerId = customer.getCustomerId();
            this.commitTransaction(em);
            customer = (Customer)em.find(Customer.class, (Object)customerId);
            this.beginTransaction(em);
            em.remove((Object)customer);
            this.commitTransaction(em);
            JPAAdvPropertiesJUnitTestCase.assertNotNull((Object)customer);
            JPAAdvPropertiesJUnitTestCase.assertTrue((String)"CustomizedEncryptor.encryptPassword() method wasn't called.", (CustomizedEncryptor.encryptPasswordCounter > 0 ? 1 : 0) != 0);
            JPAAdvPropertiesJUnitTestCase.assertTrue((String)"CustomizedEncryptor.decryptPassword() method wasn't called.", (CustomizedEncryptor.decryptPasswordCounter > 0 ? 1 : 0) != 0);
        }
        finally {
            this.closeEntityManager(em);
        }
    }
}

