/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.identitymaps.cacheinvalidation;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.DriverManager;
import org.eclipse.persistence.config.CacheIsolationType;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.sessions.DatabaseLogin;
import org.eclipse.persistence.sessions.IdentityMapAccessor;
import org.eclipse.persistence.sessions.server.ClientSession;
import org.eclipse.persistence.sessions.server.ServerSession;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestExecutor;
import org.eclipse.persistence.testing.models.employee.domain.Employee;

public class InvalidateAllExternalChangeTest
extends AutoVerifyTestCase {
    private TestExecutor executor;
    private ServerSession serverSession;
    private ReadObjectQuery query;
    private BigDecimal originalEmployeeAddressId;
    private String originalEmployeeName;
    private DatabaseLogin login;

    public void reset() {
        this.executor.resetSession();
    }

    protected void setup() {
        this.executor = this.getExecutor();
        this.executor.swapServerSession();
        this.serverSession = (ServerSession)this.getSession();
        this.serverSession.getProject().setHasIsolatedClasses(true);
        ClassDescriptor descriptor = this.serverSession.getDescriptor(Employee.class);
        descriptor.setCacheIsolation(CacheIsolationType.PROTECTED);
    }

    public void test() throws Exception {
        ClientSession clientSession = this.serverSession.acquireClientSession();
        Employee initialEmployee = (Employee)clientSession.executeQuery((DatabaseQuery)new ReadObjectQuery(Employee.class));
        InvalidateAllExternalChangeTest.assertNotNull((String)"An Employee object could not be retrieved", (Object)initialEmployee);
        this.originalEmployeeAddressId = initialEmployee.getAddressId();
        this.query = new ReadObjectQuery(Employee.class);
        Expression expression = new ExpressionBuilder().get("address").get("id").equal((Object)this.originalEmployeeAddressId);
        this.query.setSelectionCriteria(expression);
        Employee originalEmployee = (Employee)clientSession.executeQuery((DatabaseQuery)this.query);
        InvalidateAllExternalChangeTest.assertNotNull((String)"The Employee object could not be retrieved", (Object)originalEmployee);
        this.originalEmployeeName = originalEmployee.getFirstName();
        IdentityMapAccessor identityMapAccessor = this.serverSession.getIdentityMapAccessor();
        identityMapAccessor.clearQueryCache();
        identityMapAccessor.invalidateAll();
        this.login = clientSession.getLogin();
        try (Connection connection = DriverManager.getConnection(this.login.getDatabaseURL(), this.login.getUserName(), this.login.getPassword());){
            connection.prepareStatement("update EMPLOYEE set F_NAME = 'Updated' where ADDR_ID = " + this.originalEmployeeAddressId).execute();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void verify() {
        ClientSession clientSession = this.serverSession.acquireClientSession();
        Employee modifiedEmployee = (Employee)clientSession.executeQuery((DatabaseQuery)this.query);
        try {
            InvalidateAllExternalChangeTest.assertNotSame((String)"Modified Employee was not loaded from the database", (Object)this.originalEmployeeName, (Object)modifiedEmployee.getFirstName());
        }
        finally {
            try (Connection connection = DriverManager.getConnection(this.login.getDatabaseURL(), this.login.getUserName(), this.login.getPassword());){
                connection.prepareStatement("update EMPLOYEE set F_NAME = '" + this.originalEmployeeName + "' where ADDR_ID = " + this.originalEmployeeAddressId).execute();
            }
            catch (Exception x) {
                InvalidateAllExternalChangeTest.fail((String)("Could not revert employee name:\n" + Helper.printStackTraceToString((Throwable)x)));
            }
        }
    }
}

