/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.collections.map;

import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.collections.map.AggregateMapValue;
import org.eclipse.persistence.testing.models.collections.map.DirectAggregateMapHolder;
import org.eclipse.persistence.testing.tests.collections.map.TestReadDirectAggregateMapMapping;

public class TestUpdateDirectAggregateMapMapping
extends TestReadDirectAggregateMapMapping {
    protected DirectAggregateMapHolder changedHolder = null;

    @Override
    public void test() {
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        this.holders = uow.readAllObjects(DirectAggregateMapHolder.class, this.holderExp);
        this.changedHolder = (DirectAggregateMapHolder)this.holders.get(0);
        this.changedHolder.removeDirectToAggregateMapItem(1);
        AggregateMapValue mapValue = new AggregateMapValue();
        mapValue.setValue(3);
        this.changedHolder.addDirectToAggregateMapItem(3, mapValue);
        uow.commit();
        Object holderForComparison = uow.readObject((Object)this.changedHolder);
        if (!this.compareObjects(this.changedHolder, holderForComparison)) {
            throw new TestErrorException("Objects do not match after write");
        }
    }

    @Override
    public void verify() {
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
        Object initialHolder = this.holders.get(0);
        this.holders = this.getSession().readAllObjects(DirectAggregateMapHolder.class, this.holderExp);
        DirectAggregateMapHolder holder = (DirectAggregateMapHolder)this.holders.get(0);
        if (!this.compareObjects(holder, this.changedHolder)) {
            throw new TestErrorException("Objects do not match reinitialize");
        }
        if (holder.getDirectToAggregateMap().containsKey(1)) {
            throw new TestErrorException("Item that was removed is still present in map.");
        }
        AggregateMapValue value = (AggregateMapValue)holder.getDirectToAggregateMap().get(3);
        if (value.getValue() != 3) {
            throw new TestErrorException("Item was not correctly added to map");
        }
    }
}

