/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.framework;

import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.foundation.AbstractDirectMapping;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.sessions.server.ClientSession;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.framework.TransactionalTestCase;

public class WriteObjectTest
extends TransactionalTestCase {
    protected ReadObjectQuery query;
    protected Object originalObject;
    protected Object objectToBeWritten;
    protected Object objectFromDatabase;
    protected Boolean bindAllParameters = null;
    protected Boolean bindAllParametersOriginal = null;
    protected boolean makesTrivialUpdate = true;
    protected boolean testShouldMutate = true;

    public WriteObjectTest() {
        this.setDescription("The test writing of the intended object from the database and checks if it was inserted properly");
    }

    public WriteObjectTest(Object originalObject) {
        this.originalObject = originalObject;
        this.setName(this.getName() + "(" + originalObject.getClass() + ")");
        this.setDescription("The test writing of the intended object, '" + originalObject + "', from the database and checks if it was inserted properly");
    }

    public Object getOriginalObject() {
        return this.originalObject;
    }

    public Object findAndMutateDirectToFieldMappingInObject(Object objectToBeMutated, boolean isInUOW) {
        DatabaseMapping dbMapping = null;
        DatabaseMapping mutatableMapping = null;
        Object mutationString = "M";
        Class<?> objectClass = objectToBeMutated.getClass();
        ClassDescriptor descriptor = this.getSession().getProject().getClassDescriptor(objectClass);
        Vector mappings = descriptor.getMappings();
        if (isInUOW) {
            mutationString = (String)mutationString + "U";
        }
        Enumeration en = mappings.elements();
        while (en.hasMoreElements()) {
            dbMapping = (DatabaseMapping)en.nextElement();
            if (dbMapping.isPrimaryKeyMapping() || !dbMapping.isDirectToFieldMapping() || ((AbstractDirectMapping)dbMapping).hasConverter() || dbMapping.getAttributeAccessor().getAttributeClass().getName().indexOf("String") == -1) continue;
            mutatableMapping = dbMapping;
            break;
        }
        if (mutatableMapping != null) {
            mutatableMapping.setAttributeValueInObject(objectToBeMutated, (Object)(mutatableMapping.getAttributeValueFromObject(objectToBeMutated) + (String)mutationString));
        }
        return objectToBeMutated;
    }

    public boolean makesTrivialUpdate() {
        return this.makesTrivialUpdate;
    }

    public boolean testShouldMutate() {
        return this.testShouldMutate;
    }

    @Override
    public void reset() {
        if (this.bindAllParametersOriginal != null) {
            this.getSession().getLogin().setShouldBindAllParameters(this.bindAllParametersOriginal.booleanValue());
        }
        super.reset();
    }

    public void setMakesTrivialUpdate(boolean value) {
        this.makesTrivialUpdate = value;
    }

    public void setTestShouldMutate(boolean value) {
        this.testShouldMutate = value;
    }

    public void setShouldBindAllParameters(boolean value) {
        this.bindAllParameters = value;
    }

    @Override
    protected void setup() {
        if (this.shouldBindAllParameters() != null) {
            this.bindAllParametersOriginal = this.getSession().getLogin().shouldBindAllParameters();
            this.getSession().getLogin().setShouldBindAllParameters(this.shouldBindAllParameters().booleanValue());
        }
        super.setup();
        this.query = new ReadObjectQuery();
        this.query.setSelectionObject(this.originalObject);
        this.objectToBeWritten = this.getSession().executeQuery((DatabaseQuery)this.query);
        if (this.query.getDescriptor().shouldIsolateProtectedObjectsInUnitOfWork() && this.getSession().isClientSession()) {
            this.objectToBeWritten = ((ClientSession)this.getSession()).getParent().getIdentityMapAccessor().getFromIdentityMap(this.objectToBeWritten);
        }
        if (this.objectToBeWritten == null) {
            this.objectToBeWritten = this.originalObject;
            this.query = new ReadObjectQuery();
            this.query.setSelectionObject(this.originalObject);
        }
        if (!this.makesTrivialUpdate()) {
            this.objectToBeWritten = this.originalObject;
        }
    }

    public Boolean shouldBindAllParameters() {
        return this.bindAllParameters;
    }

    @Override
    protected void test() {
        if (this.makesTrivialUpdate() && this.testShouldMutate()) {
            this.objectToBeWritten = this.findAndMutateDirectToFieldMappingInObject(this.objectToBeWritten, false);
        }
        this.getDatabaseSession().writeObject(this.objectToBeWritten);
    }

    @Override
    protected void verify() {
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
        this.objectFromDatabase = this.getSession().executeQuery((DatabaseQuery)this.query);
        if (!this.compareObjects(this.objectToBeWritten, this.objectFromDatabase)) {
            throw new TestErrorException("The object inserted into the database, '" + this.objectFromDatabase + "' does not match the original, '" + this.objectToBeWritten + "'.");
        }
    }
}

