/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.unitofwork.transactionisolation;

import java.util.Vector;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.models.employee.domain.Address;
import org.eclipse.persistence.testing.models.employee.domain.Employee;

public class TransactionIsolationMergeIndirectionOriginalsExistTest
extends AutoVerifyTestCase {
    UnitOfWork unitOfWork;
    Employee original;
    String originalFirstName;

    protected void setup() throws Exception {
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        this.unitOfWork = this.getSession().acquireUnitOfWork();
    }

    public void reset() throws Exception {
        if (this.unitOfWork != null) {
            this.unitOfWork.release();
            this.unitOfWork = null;
        }
        this.unitOfWork = this.getSession().acquireUnitOfWork();
        Employee clone = (Employee)this.unitOfWork.readObject((Object)this.original);
        clone.setFirstName(this.originalFirstName);
        this.unitOfWork.commit();
        this.unitOfWork = null;
        this.originalFirstName = null;
        this.original = null;
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
    }

    public void test() {
        Employee employeeClone;
        Vector addresses = this.getSession().readAllObjects(Address.class);
        this.unitOfWork.beginEarlyTransaction();
        this.original = employeeClone = (Employee)this.unitOfWork.readObject(Employee.class);
        this.originalFirstName = this.original.getFirstName();
        employeeClone.setFirstName("elle");
        Address addressClone = employeeClone.getAddress();
        Address originalAddress = (Address)this.getSession().readObject((Object)addressClone);
        this.unitOfWork.commit();
        this.unitOfWork = null;
        Employee newOriginal = (Employee)this.getSession().getIdentityMapAccessor().getFromIdentityMap((Object)employeeClone);
        this.strongAssert(newOriginal != employeeClone, "Somehow the employee clone was merged into the shared cache.");
        Address newAddress = (Address)this.getSession().getIdentityMapAccessor().getFromIdentityMap((Object)addressClone);
        this.strongAssert(newAddress == originalAddress, "Identity was lost on address accross the 1-1");
    }
}

