/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.clientserver;

import org.eclipse.persistence.sessions.DatabaseLogin;
import org.eclipse.persistence.sessions.SessionEvent;
import org.eclipse.persistence.sessions.SessionEventAdapter;
import org.eclipse.persistence.sessions.SessionEventListener;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.sessions.server.ClientSession;
import org.eclipse.persistence.sessions.server.Server;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.models.employee.relational.EmployeeProject;

public class PreBeginTransactionFailureTest
extends AutoVerifyTestCase {
    protected Server serverSession;
    protected UnitOfWork uow;
    protected static TestErrorException expectedException = new TestErrorException("Expected exception");
    protected Exception exception;

    public void reset() {
        if (this.serverSession != null) {
            this.serverSession.logout();
            this.serverSession = null;
            this.exception = null;
        }
    }

    public void setup() {
        EmployeeProject project = new EmployeeProject();
        project.setLogin((DatabaseLogin)this.getSession().getLogin().clone());
        this.serverSession = project.createServerSession(1, 1);
        this.serverSession.setSessionLog(this.getSession().getSessionLog());
        this.serverSession.login();
        SessionListener listener = new SessionListener();
        ClientSession clientSession = this.serverSession.acquireClientSession();
        clientSession.getEventManager().addListener((SessionEventListener)listener);
        this.uow = clientSession.acquireUnitOfWork();
    }

    public void test() {
        Employee emp = new Employee();
        Employee empCopy = (Employee)this.uow.registerObject((Object)emp);
        empCopy.setFirstName("A");
        try {
            this.uow.commit();
        }
        catch (Exception ex) {
            this.exception = ex;
        }
    }

    public void verify() {
        if (!expectedException.equals(this.exception)) {
            throw new TestErrorException("A wrong exception has been thrown.");
        }
    }

    class SessionListener
    extends SessionEventAdapter {
        SessionListener() {
        }

        public void preBeginTransaction(SessionEvent event) {
            throw expectedException;
        }
    }
}

