/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.models.transparentindirection;

import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.testing.models.transparentindirection.AbstractOrder;
import org.eclipse.persistence.testing.models.transparentindirection.AbstractOrderLine;
import org.eclipse.persistence.testing.models.transparentindirection.AbstractSalesRep;

public class MappedOrder
extends AbstractOrder {
    public Map salesReps;
    public Collection contacts;
    public Map lines;

    public MappedOrder() {
    }

    public MappedOrder(String customerName) {
        super(customerName);
    }

    @Override
    public void addContact(String contact) {
        this.contacts.add(contact);
    }

    @Override
    public void addLine(AbstractOrderLine line) {
        this.lines.put(line.getKey(), line);
        line.order = this;
    }

    @Override
    public void addSalesRep(AbstractSalesRep salesRep) {
        this.salesReps.put(salesRep.getKey(), salesRep);
        salesRep.addOrder(this);
    }

    @Override
    public boolean containsContact(String contactName) {
        return this.contacts.contains(contactName);
    }

    @Override
    public boolean containsLine(AbstractOrderLine line) {
        return this.lines.containsValue(line);
    }

    @Override
    public boolean containsSalesRep(AbstractSalesRep salesRep) {
        return this.salesReps.containsValue(salesRep);
    }

    @Override
    public Object getContactContainer() {
        return this.contacts;
    }

    @Override
    public Enumeration getContactStream() {
        return new Vector(this.contacts).elements();
    }

    @Override
    public Object getLineContainer() {
        return this.lines;
    }

    @Override
    public Enumeration getLineStream() {
        return new Vector(this.lines.values()).elements();
    }

    @Override
    public int getNumberOfContacts() {
        return this.contacts.size();
    }

    @Override
    public int getNumberOfLines() {
        return this.lines.size();
    }

    @Override
    public int getNumberOfSalesReps() {
        return this.salesReps.size();
    }

    @Override
    public Object getSalesRepContainer() {
        return this.salesReps;
    }

    @Override
    public Enumeration getSalesRepStream() {
        return new Vector(this.salesReps.values()).elements();
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.salesReps = new Hashtable();
        this.contacts = new Vector();
        this.lines = new Hashtable();
    }

    @Override
    public void removeContact(String contact) {
        this.contacts.remove(contact);
    }

    @Override
    public void removeLine(AbstractOrderLine line) {
        this.lines.remove(line.getKey());
    }

    @Override
    public void removeSalesRep(AbstractSalesRep salesRep) {
        this.salesReps.remove(salesRep.getKey());
        salesRep.removeOrder(this);
    }

    @Override
    public void clearLines() {
        this.lines = new Hashtable();
    }
}

