/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.unitofwork;

import org.eclipse.persistence.descriptors.DescriptorEvent;
import org.eclipse.persistence.descriptors.DescriptorEventAdapter;
import org.eclipse.persistence.descriptors.DescriptorEventListener;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.framework.TransactionalTestCase;
import org.eclipse.persistence.testing.models.employee.domain.PhoneNumber;

public class PerformDeletesFirstIgnoreUpdateTest
extends TransactionalTestCase {
    UpdateListener phoneUpdateListener;
    DatabaseException dbException;

    public PerformDeletesFirstIgnoreUpdateTest() {
        this.setDescription("Verifies that TopLink doesn't issue UPDATE phone number after deleting it");
    }

    public void setup() {
        super.setup();
        this.phoneUpdateListener = new UpdateListener();
        this.getSession().getDescriptor(PhoneNumber.class).getEventManager().addListener((DescriptorEventListener)this.phoneUpdateListener);
    }

    public void test() {
        PhoneNumber phone = (PhoneNumber)this.getSession().readObject(PhoneNumber.class);
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        uow.setShouldPerformDeletesFirst(true);
        PhoneNumber phoneClone = (PhoneNumber)uow.registerObject((Object)phone);
        phoneClone.setNumber("0123456789");
        uow.deleteObject((Object)phoneClone);
        try {
            uow.commit();
        }
        catch (DatabaseException ex) {
            this.dbException = ex;
        }
    }

    public void verify() {
        if (this.dbException != null) {
            throw new TestErrorException("Attempted to update Phone number before delete", (Throwable)this.dbException);
        }
        if (this.phoneUpdateListener.updated) {
            throw new TestErrorException("Phone number was updated after delete");
        }
    }

    public void reset() {
        if (this.phoneUpdateListener != null) {
            super.reset();
            this.getSession().getDescriptor(PhoneNumber.class).getEventManager().removeListener((DescriptorEventListener)this.phoneUpdateListener);
            this.phoneUpdateListener = null;
            this.dbException = null;
        }
    }

    static class UpdateListener
    extends DescriptorEventAdapter {
        boolean updated;

        UpdateListener() {
        }

        public void postUpdate(DescriptorEvent event) {
            this.updated = true;
        }
    }
}

