/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.collections.map;

import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.queries.MappedKeyMapContainerPolicy;
import org.eclipse.persistence.mappings.DirectMapMapping;
import org.eclipse.persistence.mappings.ForeignReferenceMapping;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.collections.map.EntityDirectMapHolder;
import org.eclipse.persistence.testing.models.collections.map.EntityMapKey;
import org.eclipse.persistence.testing.tests.collections.map.TestReadEntityDirectMapMapping;

public class TestUpdateEntityDirectMapMapping
extends TestReadEntityDirectMapMapping {
    private boolean usePrivateOwned = false;
    protected ForeignReferenceMapping keyMapping = null;
    private boolean oldKeyPrivateOwnedValue = false;
    protected EntityDirectMapHolder changedHolder = null;

    public TestUpdateEntityDirectMapMapping() {
    }

    public TestUpdateEntityDirectMapMapping(boolean usePrivateOwned) {
        this();
        this.usePrivateOwned = usePrivateOwned;
        this.setName("TestUpdateEntityDirectMapMapping privateOwned=" + usePrivateOwned);
    }

    @Override
    public void setup() {
        DirectMapMapping mapping = (DirectMapMapping)this.getSession().getProject().getDescriptor(EntityDirectMapHolder.class).getMappingForAttributeName("entityToDirectMap");
        this.keyMapping = (ForeignReferenceMapping)((MappedKeyMapContainerPolicy)mapping.getContainerPolicy()).getKeyMapping();
        this.oldKeyPrivateOwnedValue = this.keyMapping.isPrivateOwned();
        this.keyMapping.setIsPrivateOwned(this.usePrivateOwned);
        super.setup();
    }

    @Override
    public void test() {
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        this.holders = uow.readAllObjects(EntityDirectMapHolder.class, this.holderExp);
        this.changedHolder = (EntityDirectMapHolder)this.holders.get(0);
        EntityMapKey mapKey = new EntityMapKey();
        mapKey.setId(1);
        this.changedHolder.removeEntityToDirectMapItem(mapKey);
        mapKey = new EntityMapKey();
        mapKey.setId(3);
        mapKey.setData("testData");
        mapKey = (EntityMapKey)uow.registerObject((Object)mapKey);
        this.changedHolder.addEntityDirectMapItem(mapKey, new Integer(3));
        uow.commit();
        Object holderForComparison = uow.readObject((Object)this.changedHolder);
        if (!this.compareObjects(this.changedHolder, holderForComparison)) {
            throw new TestErrorException("Objects do not match after write");
        }
    }

    @Override
    public void verify() {
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
        this.holders = this.getSession().readAllObjects(EntityDirectMapHolder.class, this.holderExp);
        EntityDirectMapHolder holder = (EntityDirectMapHolder)this.holders.get(0);
        if (!this.compareObjects(holder, this.changedHolder)) {
            throw new TestErrorException("Objects do not match reinitialize");
        }
        EntityMapKey mapKey = new EntityMapKey();
        mapKey.setId(1);
        if (holder.getEntityToDirectMap().containsKey(mapKey)) {
            throw new TestErrorException("Item that was removed is still present in map.");
        }
        mapKey = new EntityMapKey();
        mapKey.setId(3);
        Integer value = (Integer)holder.getEntityToDirectMap().get(mapKey);
        if (value != 3) {
            throw new TestErrorException("Item was not correctly added to map");
        }
        if (this.keyMapping.isPrivateOwned()) {
            ReadObjectQuery query = new ReadObjectQuery(EntityMapKey.class);
            ExpressionBuilder keys = new ExpressionBuilder();
            Expression keycriteria = keys.get("id").equal(1);
            query.setSelectionCriteria(keycriteria);
            mapKey = (EntityMapKey)this.getSession().executeQuery((DatabaseQuery)query);
            if (mapKey != null) {
                throw new TestErrorException("PrivateOwned EntityMapKey was not deleted.");
            }
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.keyMapping.setIsPrivateOwned(this.oldKeyPrivateOwnedValue);
    }
}

