/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.jpql;

import java.util.Collection;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.server.ServerSession;
import org.eclipse.persistence.testing.framework.JoinedAttributeTestHelper;
import org.eclipse.persistence.testing.framework.junit.JUnitTestCase;
import org.eclipse.persistence.testing.models.jpa.advanced.Address;
import org.eclipse.persistence.testing.models.jpa.advanced.EmployeePopulator;
import org.eclipse.persistence.testing.models.jpa.advanced.GoldBuyer;
import org.eclipse.persistence.testing.models.jpa.advanced.NativeQueryTableCreator;
import org.eclipse.persistence.testing.tests.jpa.advanced.NamedNativeQueryJUnitTest;

public class JUnitNativeQueryTestSuite
extends JUnitTestCase {
    protected String PUName = "MulitPU-1";

    public JUnitNativeQueryTestSuite() {
    }

    public JUnitNativeQueryTestSuite(String name) {
        super(name);
        this.setPuName(this.PUName);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.setName("NativeQueryTestSuite");
        suite.addTest((Test)new JUnitNativeQueryTestSuite("testSetup"));
        suite.addTest((Test)new JUnitNativeQueryTestSuite("testNativeQueryWithMixedCaseFields"));
        suite.addTest((Test)new JUnitNativeQueryTestSuite("testNativeQueryHint"));
        suite.addTest((Test)new JUnitNativeQueryTestSuite("testCaseSensitivity_GoldBuyer1"));
        suite.addTest((Test)new JUnitNativeQueryTestSuite("testNativeQueryCacheHit"));
        TestSuite NamedNativeQuerySuite = new TestSuite();
        suite.addTest(NamedNativeQueryJUnitTest.addNamedNativeQueryTests(NamedNativeQuerySuite));
        return suite;
    }

    public void testSetup() {
        ServerSession session = JUnitTestCase.getServerSession((String)this.PUName);
        EmployeePopulator employeePopulator = new EmployeePopulator();
        new NativeQueryTableCreator().replaceTables((DatabaseSession)session);
        employeePopulator.buildExamples();
        employeePopulator.persistExample((Session)session);
        JUnitNativeQueryTestSuite.clearCache((String)this.PUName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNativeQueryCacheHit() {
        Address result = null;
        EntityManager em = JUnitNativeQueryTestSuite.createEntityManager((String)this.PUName);
        Query query = em.createQuery("Select a from Address a");
        Address a = (Address)query.getResultList().get(0);
        this.closeEntityManager(em);
        em = JUnitNativeQueryTestSuite.createEntityManager((String)this.PUName);
        try {
            this.beginTransaction(em);
            query = em.createNativeQuery("Select ADDRESS_ID from CMP3_ADDRESS where ADDRESS_ID=" + a.getID(), Address.class);
            result = (Address)query.getSingleResult();
        }
        finally {
            this.rollbackTransaction(em);
            JUnitNativeQueryTestSuite.clearCache((String)this.PUName);
            this.closeEntityManager(em);
        }
        JUnitNativeQueryTestSuite.assertTrue((String)"Street from Address read using native query did not match the cache version", (result.getStreet() != null && result.getStreet().equals(a.getStreet()) ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNativeQueryWithMixedCaseFields() {
        EntityManager em = JUnitNativeQueryTestSuite.createEntityManager((String)this.PUName);
        try {
            Address expectedAddress = (Address)em.createQuery("select a from Address a").getResultList().get(0);
            Address returnedAddress = null;
            ServerSession session = JUnitTestCase.getServerSession();
            String delimiter = session.getPlatform().getStartDelimiter();
            Query q = em.createNativeQuery("Select ADDRESS_ID as " + delimiter + "aDdReSs_iD" + delimiter + ", P_CODE as " + delimiter + "P_cOdE" + delimiter + ", STREET as " + delimiter + "StReeT" + delimiter + ", PROVINCE as " + delimiter + "PrOvInCe" + delimiter + ", TYPE as " + delimiter + "TyPe" + delimiter + ", CITY as " + delimiter + "CiTy" + delimiter + ", COUNTRY as " + delimiter + "CoUnTrY" + delimiter + ", VERSION as " + delimiter + "VeRsIoN" + delimiter + " from CMP3_ADDRESS where ADDRESS_ID = " + expectedAddress.getID(), Address.class);
            returnedAddress = (Address)q.getSingleResult();
            JUnitNativeQueryTestSuite.assertNotNull((String)"no address returned", (Object)returnedAddress);
            JUnitNativeQueryTestSuite.assertTrue((String)"returned address does not match the expected address", (boolean)session.compareObjects((Object)returnedAddress, (Object)expectedAddress));
            q = em.createNativeQuery("Select ADDRESS_ID, P_CODE, STREET, PROVINCE, TYPE, CITY, COUNTRY, VERSION from CMP3_ADDRESS where ADDRESS_ID = " + expectedAddress.getID(), "address-case-sensitive-map");
            returnedAddress = (Address)q.getSingleResult();
            JUnitNativeQueryTestSuite.assertNotNull((String)"no address returned", (Object)returnedAddress);
            JUnitNativeQueryTestSuite.assertTrue((String)"returned address does not match the expected address", (boolean)session.compareObjects((Object)returnedAddress, (Object)expectedAddress));
        }
        finally {
            this.closeEntityManager(em);
        }
    }

    public void testNativeQueryHint() {
        EntityManager em = JUnitNativeQueryTestSuite.createEntityManager((String)this.PUName);
        Query query = em.createNativeQuery("Select * from CMP3_ADDRESS");
        query.setHint("somehint", (Object)"whatever");
        query.setHint("eclipselink.jdbc.bind-parameters", (Object)"false");
        query.getResultList();
        JUnitNativeQueryTestSuite.clearCache((String)this.PUName);
        this.closeEntityManager(em);
    }

    public void testCaseSensitivity_GoldBuyer1() {
        String errorMsg;
        EntityManager em = JUnitNativeQueryTestSuite.createEntityManager((String)this.PUName);
        ServerSession session = JUnitTestCase.getServerSession((String)this.PUName);
        Query jpaquery = em.createQuery("Select b from GoldBuyer b");
        List jpaQueryResults = jpaquery.getResultList();
        this.closeEntityManager(em);
        JUnitNativeQueryTestSuite.clearCache((String)this.PUName);
        em = JUnitNativeQueryTestSuite.createEntityManager((String)this.PUName);
        Query query = em.createNativeQuery("Select * from CMP3_BUYER WHERE (DTYPE = 'GoldBuyer')", GoldBuyer.class);
        List nativeQueryResults = query.getResultList();
        this.closeEntityManager(em);
        JUnitNativeQueryTestSuite.clearCache((String)this.PUName);
        if (nativeQueryResults.isEmpty() || ((GoldBuyer)nativeQueryResults.get(0)).getDescription() == null || ((GoldBuyer)nativeQueryResults.get(0)).getDescription().length() == 0) {
            JUnitNativeQueryTestSuite.fail((String)"testCaseSensitivity_GoldBuyer1 failed to return ");
        }
        if ((errorMsg = JoinedAttributeTestHelper.compareCollections((Collection)jpaQueryResults, (Collection)nativeQueryResults, (ClassDescriptor)session.getClassDescriptor(GoldBuyer.class), (AbstractSession)session)).length() > 0) {
            JUnitNativeQueryTestSuite.fail((String)errorMsg);
        }
    }

    public void testCaseSensitivity2() {
        EntityManager em = JUnitNativeQueryTestSuite.createEntityManager((String)this.PUName);
        Query query = em.createNativeQuery("Select * from CMP3_ADDRESS");
        query.setHint("somehint", (Object)"whatever");
        query.setHint("eclipselink.jdbc.bind-parameters", (Object)"false");
        query.getResultList();
        this.closeEntityManager(em);
    }
}

