/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.models.jpa.xml.merge.advanced;

import java.io.Serializable;
import java.io.StringWriter;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.IdClass;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import org.eclipse.persistence.testing.models.jpa.xml.merge.advanced.Employee;
import org.eclipse.persistence.testing.models.jpa.xml.merge.advanced.PhoneNumberPK;

@IdClass(value=PhoneNumberPK.class)
@Entity(name="AnnMergePhoneNumber")
@Table(name="CMP3_ANN_MERGE_PHONENUMBER")
public class PhoneNumber
implements Serializable {
    private String number;
    private String type;
    private Employee owner;
    private Integer id;
    private String areaCode;

    public PhoneNumber() {
        this("", "###", "#######");
    }

    public PhoneNumber(String type, String theAreaCode, String theNumber) {
        this.type = type;
        this.areaCode = theAreaCode;
        this.number = theNumber;
        this.owner = null;
    }

    @Id
    @Column(name="ANN_MERGE_OWNER_ID", insertable=false, updatable=false)
    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    @Column(name="ANN_MERGE_NUMB")
    public String getNumber() {
        return this.number;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    @Id
    @Column(name="ANN_MERGE_TYPE")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @Column(name="ANN_MERGE_AREA_CODE")
    public String getAreaCode() {
        return this.areaCode;
    }

    public void setAreaCode(String areaCode) {
        this.areaCode = areaCode;
    }

    @ManyToOne
    @JoinColumn(name="ANN_MERGE_OWNER_ID", referencedColumnName="ANN_MERGE_EMP_ID")
    public Employee getOwner() {
        return this.owner;
    }

    public void setOwner(Employee owner) {
        this.owner = owner;
    }

    public String toString() {
        StringWriter writer = new StringWriter();
        writer.write("PhoneNumber[");
        writer.write(this.getType());
        writer.write("]: (");
        writer.write(this.getAreaCode());
        writer.write(") ");
        int numberLength = this.getNumber().length();
        writer.write(this.getNumber().substring(0, Math.min(3, numberLength)));
        if (numberLength > 3) {
            writer.write("-");
            writer.write(this.getNumber().substring(3, Math.min(7, numberLength)));
        }
        return writer.toString();
    }

    public PhoneNumberPK buildPK() {
        PhoneNumberPK pk = new PhoneNumberPK();
        pk.setId(this.getOwner().getId());
        pk.setType(this.getType());
        return pk;
    }
}

