/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.transactions;

import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.models.employee.domain.EmployeePopulator;

public class UpdateCommitTransactionTest
extends AutoVerifyTestCase {
    Employee employee = this.createEmployee();
    Expression searchExpression = this.createSearchExpression(this.employee.getFirstName(), this.employee.getLastName());
    String oldFirstName;
    String oldLastName;

    private Employee createEmployee() {
        this.employee = (Employee)new EmployeePopulator().basicEmployeeExample1();
        this.employee.setFirstName("Timugen");
        this.employee.setLastName("Singaera");
        this.employee.addResponsibility("Answer the phones.");
        this.oldFirstName = this.employee.getFirstName();
        this.oldLastName = this.employee.getLastName();
        return this.employee;
    }

    private Expression createSearchExpression(String firstName, String lastName) {
        ExpressionBuilder expressionBuilder = new ExpressionBuilder();
        Expression exp1 = expressionBuilder.get("firstName").equal((Object)firstName);
        Expression exp2 = expressionBuilder.get("lastName").equal((Object)lastName);
        return exp1.or(exp2);
    }

    public String getDescription() {
        return "This test verifies that the commit transaction feature works for database inserts.";
    }

    private Employee getEmployee() {
        return this.employee;
    }

    private Expression getSearchExpression() {
        return this.searchExpression;
    }

    public void reset() {
        Expression newSearchExpression;
        DatabaseSession session = this.getDatabaseSession();
        Employee databaseEmployee = (Employee)session.readObject(Employee.class, this.getSearchExpression());
        if (databaseEmployee != null) {
            session.deleteObject((Object)databaseEmployee);
        }
        if ((databaseEmployee = (Employee)session.readObject(Employee.class, newSearchExpression = this.createSearchExpression(this.oldFirstName, this.oldLastName))) != null) {
            session.deleteObject((Object)databaseEmployee);
        }
        this.employee = this.createEmployee();
        this.searchExpression = this.createSearchExpression(this.employee.getFirstName(), this.employee.getLastName());
    }

    protected void resetVerify() {
        Session session = this.getSession();
        Employee databaseEmployee = (Employee)session.readObject(Employee.class, this.getSearchExpression());
        if (databaseEmployee != null) {
            throw new TestErrorException("Employee object has not been removed from the database");
        }
        Expression newSearchExpression = this.createSearchExpression("Alex", "Runparts");
        databaseEmployee = (Employee)session.readObject(Employee.class, newSearchExpression);
        if (databaseEmployee != null) {
            throw new TestErrorException("Employee object has not been removed from the database");
        }
    }

    protected void setup() {
        this.getDatabaseSession().insertObject((Object)this.getEmployee());
    }

    protected void test() {
        DatabaseSession session = this.getDatabaseSession();
        Employee databaseEmployee = (Employee)session.readObject(Employee.class, this.getSearchExpression());
        session.beginTransaction();
        databaseEmployee.setFirstName("Alex");
        databaseEmployee.setLastName("Runparts");
        this.employee = databaseEmployee;
        session.updateObject((Object)databaseEmployee);
        session.commitTransaction();
    }

    protected void verify() {
        Session session = this.getSession();
        Employee databaseEmployee = (Employee)session.readObject(Employee.class, this.getSearchExpression());
        if (databaseEmployee != null) {
            throw new TestErrorException("Employee object should have been updated after commit transaction");
        }
        this.searchExpression = this.createSearchExpression(this.employee.getFirstName(), this.employee.getLastName());
        databaseEmployee = (Employee)session.readObject(Employee.class, this.searchExpression);
        if (databaseEmployee == null) {
            throw new TestErrorException("Database should have updated employee after commit transaction");
        }
    }
}

