/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.sessioncache;

import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.identitymaps.IdentityMap;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.mapping.Employee;
import org.eclipse.persistence.testing.models.mapping.Shipment;

public class ReadReferencedObjectNotInSessionCacheTest
extends TestCase {
    private Employee objectInCache;
    private int originalSize;

    public ReadReferencedObjectNotInSessionCacheTest() {
        this.setDescription("This test ensures that referenced objects are put in the session cache");
    }

    protected void setup() {
        this.checkNoWaitSupported();
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
        this.objectInCache = (Employee)this.getSession().readObject(Employee.class, new ExpressionBuilder().get("lastName").equal((Object)"White"));
        this.originalSize = this.objectInCache.getShipments().size();
        this.getAbstractSession().beginTransaction();
    }

    protected void test() {
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        ReadObjectQuery query = new ReadObjectQuery((Object)this.objectInCache);
        Employee emp = (Employee)uow.executeQuery((DatabaseQuery)query);
        ReadObjectQuery query2 = new ReadObjectQuery(Shipment.class);
        query2.setLockMode((short)2);
        Shipment comp = (Shipment)uow.executeQuery((DatabaseQuery)query2);
        emp.getShipments().add(comp);
        uow.commit();
    }

    protected void verify() {
        Employee empVerify = (Employee)this.getSession().readObject((Object)this.objectInCache);
        if (empVerify == null) {
            throw new TestErrorException("Employee should have been in session cache.");
        }
        if (empVerify.getShipments() == null) {
            throw new TestErrorException("Employee's shipments should not be null.");
        }
        if (empVerify.getShipments().size() != this.originalSize + 1) {
            throw new TestErrorException("Shipment was not added to Employee.");
        }
        IdentityMap im = ((AbstractSession)this.getSession()).getIdentityMapAccessorInstance().getIdentityMap(Shipment.class);
        if (im == null || im.getSize() == 0) {
            throw new TestErrorException("Shipment should have been put into session cache.");
        }
    }

    public void reset() throws Exception {
        this.getAbstractSession().rollbackTransaction();
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
    }
}

