/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.queries.inmemory;

import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.models.employee.domain.Address;
import org.eclipse.persistence.testing.models.employee.domain.Employee;

public class MemoryQueryForFunctionsAcrossOneToManyAcrossOneToOneMapping
extends TestCase {
    protected Employee employee;
    protected ReadAllQuery queryAll;
    protected ReadObjectQuery queryObject;
    protected Vector allEmployees;
    protected Vector employees;

    public void reset() {
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
    }

    public void setup() {
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        this.allEmployees = new Vector();
        this.employees = new Vector();
        Vector managedEmps = new Vector();
        Vector emps = new Vector();
        Vector<Address> addressVector = new Vector<Address>();
        this.queryAll = new ReadAllQuery();
        this.queryAll.setReferenceClass(Employee.class);
        this.queryAll.setSelectionCriteria(new ExpressionBuilder().anyOf("managedEmployees").get("address").get("city").toUpperCase().greaterThan((Object)"MONTREAL"));
        this.getSession().removeQuery("getAllEmployees");
        this.getSession().addQuery("getAllEmployees", (DatabaseQuery)this.queryAll);
        this.allEmployees = (Vector)this.getSession().executeQuery("getAllEmployees");
        Enumeration enumtr = this.allEmployees.elements();
        while (enumtr.hasMoreElements()) {
            Object anEmp = enumtr.nextElement();
            managedEmps = ((Employee)anEmp).getManagedEmployees();
            Enumeration enum2 = managedEmps.elements();
            while (enum2.hasMoreElements()) {
                Object aNewEmp = enum2.nextElement();
                Address address = ((Employee)aNewEmp).getAddress();
                emps = ((Employee)aNewEmp).getManagedEmployees();
                addressVector.add(address);
            }
        }
    }

    public void test() {
        this.queryObject = new ReadObjectQuery();
        this.queryObject.setReferenceClass(Employee.class);
        this.queryObject.checkCacheOnly();
        ExpressionBuilder bldr = new ExpressionBuilder();
        Expression exp = bldr.anyOf("managedEmployees").get("address").get("city").toUpperCase().equal((Object)"OTTAWA");
        this.queryObject.setSelectionCriteria(exp);
        this.employee = (Employee)this.getSession().executeQuery((DatabaseQuery)this.queryObject);
    }
}

