/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.insurance;

import junit.framework.Test;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.DeleteObjectTest;
import org.eclipse.persistence.testing.framework.InsertObjectTest;
import org.eclipse.persistence.testing.framework.ReadAllTest;
import org.eclipse.persistence.testing.framework.ReadObjectTest;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.framework.TestModel;
import org.eclipse.persistence.testing.framework.TestSuite;
import org.eclipse.persistence.testing.framework.UnitOfWorkBasicUpdateObjectTest;
import org.eclipse.persistence.testing.framework.WriteObjectTest;
import org.eclipse.persistence.testing.models.insurance.Address;
import org.eclipse.persistence.testing.models.insurance.BicyclePolicy;
import org.eclipse.persistence.testing.models.insurance.Claim;
import org.eclipse.persistence.testing.models.insurance.InsuranceSystem;
import org.eclipse.persistence.testing.models.insurance.Policy;
import org.eclipse.persistence.testing.models.insurance.PolicyHolder;
import org.eclipse.persistence.tools.schemaframework.PopulationManager;

public class InsuranceBasicTestModel
extends TestModel {
    public static junit.framework.TestSuite suite() {
        return new InsuranceBasicTestModel();
    }

    public InsuranceBasicTestModel() {
        this.setDescription("This model tests reading/writing/deleting using the insurance demo.");
    }

    public void addRequiredSystems() {
        this.addRequiredSystem(new InsuranceSystem());
    }

    public void addTests() {
        this.addTest((Test)InsuranceBasicTestModel.getReadObjectTestSuite());
        this.addTest((Test)InsuranceBasicTestModel.getReadAllTestSuite());
        this.addTest((Test)InsuranceBasicTestModel.getInsertObjectTestSuite());
        this.addTest((Test)InsuranceBasicTestModel.getUpdateObjectTestSuite());
        this.addTest((Test)InsuranceBasicTestModel.getDeleteObjectTestSuite());
        this.addTest((Test)InsuranceBasicTestModel.getDeletePrivateOwnedTestSuite());
    }

    public static PolicyHolder buildExamplePolicyHolder() {
        PolicyHolder holder = new PolicyHolder();
        holder.setFirstName("Bobby");
        holder.setLastName("Jones");
        holder.setMale();
        holder.setSsn(12345L);
        holder.setBirthDate(Helper.dateFromString((String)"1950/04/30"));
        holder.setOccupation("Software Engineer");
        holder.setAddress(Address.example1());
        return holder;
    }

    public static TestSuite getDeleteObjectTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("InsuranceDeleteObjectTestSuite");
        suite.setDescription("This suite tests the deletion of each object in the insurance demo.");
        Class<PolicyHolder> holderClass = PolicyHolder.class;
        PopulationManager manager = PopulationManager.getDefaultManager();
        suite.addTest((Test)new DeleteObjectTest(manager.getObject(holderClass, "example1")));
        suite.addTest((Test)new DeleteObjectTest(manager.getObject(holderClass, "example2")));
        suite.addTest((Test)new DeleteObjectTest(manager.getObject(holderClass, "example3")));
        suite.addTest((Test)new DeleteObjectTest(manager.getObject(holderClass, "example4")));
        return suite;
    }

    public static TestSuite getDeletePrivateOwnedTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("InsuranceDeletePrivateOwnedTestSuite");
        suite.setDescription("This suite tests the deletion of privately owned objects.");
        suite.addTest((Test)new RemovePrivatelyOwnedTestCase());
        return suite;
    }

    public static TestSuite getInsertObjectTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("InsuranceInsertObjectTestSuite");
        suite.setDescription("This suite tests the insertion of each object in the insurance demo.");
        suite.addTest((Test)new InsertObjectTest((Object)InsuranceBasicTestModel.buildExamplePolicyHolder()));
        return suite;
    }

    public static TestSuite getReadAllTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("InsuranceReadAllTestSuite");
        suite.setDescription("This suite tests the reading of all the objects of each class in the insurance demo.");
        PopulationManager manager = PopulationManager.getDefaultManager();
        suite.addTest((Test)new ReadAllTest(PolicyHolder.class, 4));
        suite.addTest((Test)new ReadAllTest(Policy.class, 5));
        suite.addTest((Test)new ReadAllTest(Claim.class, 7));
        return suite;
    }

    public static TestSuite getReadObjectTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("InsuranceReadObjectTestSuite");
        suite.setDescription("This suite test the reading of each object in the insurance demo.");
        Class<PolicyHolder> holderClass = PolicyHolder.class;
        PopulationManager manager = PopulationManager.getDefaultManager();
        suite.addTest((Test)new ReadObjectTest(manager.getObject(holderClass, "example1")));
        suite.addTest((Test)new ReadObjectTest(manager.getObject(holderClass, "example2")));
        suite.addTest((Test)new ReadObjectTest(manager.getObject(holderClass, "example3")));
        suite.addTest((Test)new ReadObjectTest(manager.getObject(holderClass, "example4")));
        return suite;
    }

    public static TestSuite getUpdateObjectTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("InsuranceUpdateObjectTestSuite");
        suite.setDescription("This suite tests the updating of each object in the insurance demo.");
        Class<PolicyHolder> holderClass = PolicyHolder.class;
        PopulationManager manager = PopulationManager.getDefaultManager();
        suite.addTest((Test)new WriteObjectTest(manager.getObject(holderClass, "example1")));
        suite.addTest((Test)new UnitOfWorkBasicUpdateObjectTest(manager.getObject(holderClass, "example1")));
        suite.addTest((Test)new UnitOfWorkBasicUpdateObjectTest(manager.getObject(holderClass, "example2")));
        suite.addTest((Test)new UnitOfWorkBasicUpdateObjectTest(manager.getObject(holderClass, "example3")));
        suite.addTest((Test)new UnitOfWorkBasicUpdateObjectTest(manager.getObject(holderClass, "example4")));
        return suite;
    }

    public static class RemovePrivatelyOwnedTestCase
    extends TestCase {
        public RemovePrivatelyOwnedTestCase() {
            this.setName("RemovePrivatelyOwnedTestCase");
        }

        public void test() {
            UnitOfWork uow = this.getSession().acquireUnitOfWork();
            BicyclePolicy policy = BicyclePolicy.example1();
            uow.registerObject((Object)policy);
            uow.commit();
            long policyNumber = policy.getPolicyNumber();
            int nClaims = policy.getClaims().size();
            uow = this.getSession().acquireUnitOfWork();
            BicyclePolicy policyClone = (BicyclePolicy)uow.registerObject((Object)policy);
            Claim claimToRemove = (Claim)policyClone.getClaims().get(0);
            policyClone.getClaims().remove(claimToRemove);
            uow.commit();
            ReadObjectQuery query = new ReadObjectQuery((Object)claimToRemove);
            query.shouldCheckCacheOnly();
            Claim claimToRemoveCache = (Claim)this.getSession().executeQuery((DatabaseQuery)query);
            int nClaimsNewCache = policy.getClaims().size();
            this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
            Claim claimToRemoveDb = (Claim)this.getSession().readObject((Object)claimToRemove);
            policy = (BicyclePolicy)this.getSession().readObject((Object)policy);
            int nClaimsNewDb = policy.getClaims().size();
            uow = this.getSession().acquireUnitOfWork();
            uow.deleteObject((Object)policy);
            uow.commit();
            String errorMsg = "";
            if (nClaims == nClaimsNewCache) {
                errorMsg = errorMsg + "Cache: claim has not been removed from policy; ";
            }
            if (claimToRemoveCache != null) {
                errorMsg = errorMsg + "Cache: claim has not been deleted; ";
            }
            if (nClaims == nClaimsNewDb || claimToRemoveDb != null) {
                errorMsg = errorMsg + "DB: Claim has not been deleted";
            }
            if (errorMsg.length() > 0) {
                throw new TestErrorException(errorMsg);
            }
        }
    }
}

