/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.dynamic.projectxml;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import org.eclipse.persistence.dynamic.DynamicClassLoader;
import org.eclipse.persistence.dynamic.DynamicTypeBuilder;
import org.eclipse.persistence.exceptions.XMLMarshalException;
import org.eclipse.persistence.sessions.DatabaseLogin;
import org.junit.Test;

public class InvalidConfig {
    public static final String PACKAGE_PREFIX = InvalidConfig.class.getPackage().getName();
    static final String INVALID_PROJECT_XML = PACKAGE_PREFIX.replace('.', '/') + "/bar.xml";

    @Test(expected=NullPointerException.class)
    public void nullResource() throws Exception {
        DynamicTypeBuilder.loadDynamicProject((String)null, null, null);
    }

    @Test(expected=NullPointerException.class)
    public void nullClassLoader() throws Exception {
        File temp = File.createTempFile("foo", ".txt");
        temp.deleteOnExit();
        FileInputStream fis = new FileInputStream(temp);
        DynamicTypeBuilder.loadDynamicProject((InputStream)fis, (DatabaseLogin)new DatabaseLogin(), null);
    }

    @Test(expected=XMLMarshalException.class)
    public void invalidResource() throws Exception {
        DynamicClassLoader dynamicClassLoader = new DynamicClassLoader(InvalidConfig.class.getClassLoader());
        InputStream is = dynamicClassLoader.getResourceAsStream(INVALID_PROJECT_XML);
        DynamicTypeBuilder.loadDynamicProject((InputStream)is, (DatabaseLogin)new DatabaseLogin(), (DynamicClassLoader)dynamicClassLoader);
    }
}

