/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.directmap;

import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.sessions.changesets.UnitOfWorkChangeSet;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.directmap.DirectMapMappings;

public class DirectMapUnitOfWorkTest
extends AutoVerifyTestCase {
    boolean m_exceptionCaught;
    DirectMapMappings mapsQueryResult;

    public DirectMapUnitOfWorkTest() {
        this.setDescription("Tests changing a DirectMap Withing a UnitOFWork");
    }

    public void setup() throws Exception {
        this.m_exceptionCaught = false;
        this.beginTransaction();
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
    }

    public void reset() {
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
        this.rollbackTransaction();
    }

    public void test() throws Exception {
        UnitOfWork uow1 = this.getSession().acquireUnitOfWork();
        DirectMapMappings maps = (DirectMapMappings)uow1.registerObject((Object)new DirectMapMappings());
        maps.directMap.put(new Integer(1), "bogus");
        maps.directMap.put(new Integer(3), "third");
        uow1.commit();
        UnitOfWork uow2 = this.getSession().acquireUnitOfWork();
        DirectMapMappings mapsClone = (DirectMapMappings)uow2.registerObject((Object)maps);
        mapsClone.directMap.put(new Integer(2), "axemen");
        mapsClone.directMap.put(new Integer(1), "guy");
        UnitOfWorkChangeSet changes = uow2.getCurrentChanges();
        uow2.commit();
        ReadObjectQuery query = new ReadObjectQuery((Object)mapsClone);
        this.mapsQueryResult = (DirectMapMappings)this.getSession().executeQuery((DatabaseQuery)query);
    }

    public void verify() throws Exception {
        if (!this.mapsQueryResult.directMap.containsKey(new Integer(1))) {
            throw new TestErrorException("Change set did not merge into cache properly");
        }
        if (!this.mapsQueryResult.directMap.get(new Integer(1)).equals("guy")) {
            throw new TestErrorException("Change set did not merge into cache properly");
        }
        if (!this.mapsQueryResult.directMap.containsKey(new Integer(2))) {
            throw new TestErrorException("Change set did not merge into cache properly");
        }
        if (!this.mapsQueryResult.directMap.get(new Integer(2)).equals("axemen")) {
            throw new TestErrorException("Change set did not merge into cache properly");
        }
        if (!this.mapsQueryResult.directMap.containsKey(new Integer(3))) {
            throw new TestErrorException("Change set did not merge into cache properly");
        }
    }
}

