/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.collections;

import java.math.BigDecimal;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.models.collections.Location;
import org.eclipse.persistence.testing.models.collections.Restaurant;

public class CollectionInsertDetectionTest
extends AutoVerifyTestCase {
    public void reset() {
        this.rollbackTransaction();
    }

    protected void setup() {
        this.beginTransaction();
    }

    protected void test() {
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        uow.dontPerformValidation();
        Restaurant resClone = (Restaurant)uow.readObject(Restaurant.class);
        Location location = Location.example1();
        resClone.addLocation(location);
        uow.assignSequenceNumbers();
        BigDecimal id = location.getId();
        CollectionInsertDetectionTest.assertNotNull((String)"Location ID should be assigned", (Object)id);
        uow.commit();
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        CollectionInsertDetectionTest.assertNotNull((String)"Location object was not inserted", (Object)this.getSession().readObject((Object)location));
    }
}

