/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.clientserver;

import java.util.Vector;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.models.employee.domain.Project;
import org.eclipse.persistence.testing.tests.clientserver.Server;

public class AnotherClient
extends Thread {
    protected Server server;
    protected Session clientSession;
    protected Session session;
    protected UnitOfWork unitOfWork;
    protected int index;

    public AnotherClient(Server server, int index, Session session) {
        this.server = server;
        this.session = session;
        this.index = index;
        this.clientSession = server.serverSession.acquireClientSession();
    }

    public void release() {
        this.clientSession.release();
    }

    @Override
    public void run() {
        try {
            this.unitOfWork = this.clientSession.acquireUnitOfWork();
            ReadAllQuery raq = new ReadAllQuery();
            raq.addAscendingOrdering("id");
            raq.setReferenceClass(Project.class);
            Vector projects = (Vector)this.unitOfWork.executeQuery((DatabaseQuery)raq);
            Project project = (Project)projects.elementAt(this.index);
            project.setName(new Integer(this.index).toString());
            this.unitOfWork.commit();
        }
        catch (Exception exception) {
            this.server.errorOccured = true;
            exception.printStackTrace(System.out);
        }
    }
}

