/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.models.jpa.xml.merge.incompletemappings.nonowning;

import java.io.Serializable;
import java.util.Collection;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import javax.persistence.Version;
import org.eclipse.persistence.testing.models.jpa.xml.merge.incompletemappings.nonowning.Address;
import org.eclipse.persistence.testing.models.jpa.xml.merge.incompletemappings.nonowning.Order;

@Entity(name="XMLIncompleteCustomer")
@Table(name="CMP3_XML_INC_CUSTOMER")
public class Customer
implements Serializable {
    private Integer customerId;
    private int version;
    private String city;
    private String name;
    private Collection<Order> orders;
    private Address billingAddress;

    @Id
    @GeneratedValue(strategy=GenerationType.TABLE, generator="XML_INCOMPLETE_CUSTOMER_TABLE_GENERATOR")
    @TableGenerator(name="XML_INCOMPLETE_CUSTOMER_TABLE_GENERATOR", table="CMP3_XML_INC_CUSTOMER_SEQ", pkColumnName="SEQ_NAME", valueColumnName="SEQ_COUNT", pkColumnValue="CUST_SEQ")
    @Column(name="CUST_ID")
    public Integer getCustomerId() {
        return this.customerId;
    }

    public void setCustomerId(Integer id) {
        this.customerId = id;
    }

    @Version
    @Column(name="CUST_VERSION")
    public int getVersion() {
        return this.version;
    }

    protected void setVersion(int version) {
        this.version = version;
    }

    public Address getBillingAddress() {
        return this.billingAddress;
    }

    protected void setBillingAddress(Address billingAddress) {
        this.billingAddress = billingAddress;
    }

    public String getCity() {
        return this.city;
    }

    public void setCity(String aCity) {
        this.city = aCity;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String aName) {
        this.name = aName;
    }

    @OneToMany(cascade={CascadeType.ALL}, mappedBy="customer")
    public Collection<Order> getOrders() {
        return this.orders;
    }

    public void setOrders(Collection<Order> newValue) {
        this.orders = newValue;
    }

    public void addOrder(Order anOrder) {
        this.getOrders().add(anOrder);
        anOrder.setCustomer(this);
    }

    public void removeOrder(Order anOrder) {
        this.getOrders().remove(anOrder);
    }
}

