/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.advanced;

import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.internal.jpa.EntityManagerImpl;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.jpa.advanced.Employee;
import org.eclipse.persistence.testing.tests.jpa.EntityContainerTestBase;

public class XMLAnnotationMergingTest
extends EntityContainerTestBase {
    protected boolean reset = false;
    protected Exception m_exception;

    @Override
    public void setup() {
        super.setup();
        this.reset = true;
        ((EntityManagerImpl)this.getEntityManager()).getActiveSession().getIdentityMapAccessor().initializeAllIdentityMaps();
    }

    @Override
    public void reset() {
        if (this.reset) {
            this.reset = false;
        }
        super.reset();
    }

    public void test() throws Exception {
        try {
            this.getEntityManager().createNamedQuery("findAllEmployeesByFirstName").setParameter("firstname", (Object)"Guy").getResultList();
        }
        catch (Exception e) {
            this.m_exception = e;
        }
    }

    public void verify() {
        if (this.m_exception != null) {
            throw new TestErrorException("Our named query from Employee was lost in the XML/Annotation merging. " + this.m_exception);
        }
        ClassDescriptor descriptor = ((EntityManagerImpl)this.getEntityManager()).getActiveSession().getClassDescriptor(Employee.class);
        if (descriptor.getMappingForAttributeName("lastName") == null) {
            throw new TestErrorException("The mapping for [lastName] was was lost in the XML/Annotation merging.");
        }
        if (descriptor.getMappingForAttributeName("manager") == null) {
            throw new TestErrorException("The mapping for [manager] was lost in the XML/Annotation merging.");
        }
    }
}

