/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.transparentindirection;

import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.framework.TransactionalTestCase;
import org.eclipse.persistence.testing.models.transparentindirection.Dog;
import org.eclipse.persistence.testing.models.transparentindirection.SalesRep;

public class UpdateDogTest
extends TransactionalTestCase {
    public Dog theDog;
    public SalesRep newRep;

    public void test() {
        Session session = this.getSession();
        UnitOfWork uow = session.acquireUnitOfWork();
        this.theDog = (Dog)uow.readObject(Dog.class);
        ExpressionBuilder eb = new ExpressionBuilder();
        this.newRep = (SalesRep)uow.readObject(SalesRep.class, eb.get("name").notEqual((Object)this.theDog.getOwner().getKey()));
        this.theDog.setOwner(this.newRep);
        try {
            uow.commit();
        }
        catch (DatabaseException ex) {
            throw new TestErrorException(ex.toString());
        }
    }

    public void verify() {
        Session session = this.getSession();
        session.getIdentityMapAccessor().initializeIdentityMap(Dog.class);
        this.theDog = (Dog)session.readObject(Dog.class);
        if (this.newRep.getKey() != this.theDog.getOwner().getKey()) {
            throw new TestErrorException("The Dog object was not properly updated!");
        }
    }
}

