/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.transparentindirection;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.persistence.descriptors.changetracking.MapChangeEvent;
import org.eclipse.persistence.indirection.IndirectCollectionsFactory;
import org.eclipse.persistence.indirection.IndirectMap;
import org.eclipse.persistence.indirection.ValueHolderInterface;
import org.eclipse.persistence.internal.indirection.QueryBasedValueHolder;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReadQuery;
import org.eclipse.persistence.sessions.DatabaseRecord;
import org.eclipse.persistence.testing.tests.transparentindirection.TestSession;
import org.eclipse.persistence.testing.tests.transparentindirection.ZTestCase;
import org.eclipse.persistence.testing.tests.transparentindirection.ZTestSuite;

public class IndirectMapTestAPI
extends ZTestCase {
    private Hashtable<String, String> map;
    private IndirectMap<String, String> testMap;
    private Listener testMapLsn;
    private Class<? extends IndirectMap> cls;
    private boolean useListener;

    public IndirectMapTestAPI(String name) {
        this(name, null, true);
    }

    public IndirectMapTestAPI(String name, Class<? extends IndirectMap> cls, boolean useListener) {
        super(name);
        this.cls = cls;
        this.useListener = useListener;
    }

    public static TestSuite getTestSuiteFor(Class<? extends IndirectMap> cls, boolean useListener) {
        ZTestSuite ts = new ZTestSuite("Suite for " + cls.getName() + "(useListener: " + useListener + ")");
        Enumeration tests = ts.methodNamesStartingWithTestFor(IndirectMapTestAPI.class);
        while (tests.hasMoreElements()) {
            ts.addTest((Test)new IndirectMapTestAPI((String)tests.nextElement(), cls, useListener));
        }
        return ts;
    }

    protected void assertElementsEqual(String message, Map expected, Map actual) {
        if (expected == actual) {
            return;
        }
        if (expected.size() != actual.size()) {
            IndirectMapTestAPI.assertTrue((String)this.notEqualsMessage(message, expected, actual), (boolean)false);
        }
        for (Object key : expected.keySet()) {
            if (expected.get(key).equals(actual.get(key))) continue;
            IndirectMapTestAPI.assertTrue((String)this.notEqualsMessage(message, expected, actual), (boolean)false);
        }
    }

    protected void assertElementsEqual(Map expected, Map actual) {
        this.assertElementsEqual("", expected, actual);
    }

    @Override
    protected void setUp() {
        super.setUp();
        this.map = this.setUpMap();
        Hashtable<String, String> temp = new Hashtable<String, String>(this.map);
        QueryBasedValueHolder vh = new QueryBasedValueHolder((ReadQuery)new ReadAllQuery(), (AbstractRecord)new DatabaseRecord(), (AbstractSession)new TestSession(temp));
        if (this.cls == null) {
            this.testMap = IndirectCollectionsFactory.createIndirectMap();
        } else {
            try {
                this.testMap = this.cls.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new RuntimeException(e);
            }
        }
        this.testMap.setValueHolder((ValueHolderInterface)vh);
        if (this.useListener) {
            this.testMapLsn = new Listener();
            this.testMap._persistence_setPropertyChangeListener((PropertyChangeListener)this.testMapLsn);
        }
    }

    protected Hashtable<String, String> setUpMap() {
        Hashtable<String, String> result = new Hashtable<String, String>();
        result.put("zero", "000");
        result.put("one", "111");
        result.put("two", "222");
        result.put("three", "333");
        result.put("four", "444");
        result.put("five", "555");
        result.put("six", "666");
        result.put("seven", "777");
        result.put("eight", "888");
        result.put("nine", "999");
        return result;
    }

    @Override
    protected void tearDown() {
        super.tearDown();
        if (this.useListener) {
            this.testMapLsn.events.clear();
        }
    }

    public void testClear() {
        int originalSize = this.testMap.size();
        this.map.clear();
        this.testMap.clear();
        IndirectMapTestAPI.assertEquals(this.map, this.testMap);
        IndirectMapTestAPI.assertTrue((boolean)this.testMap.isEmpty());
        this.assertRemoveEvents(originalSize);
    }

    public void testContains() {
        IndirectMapTestAPI.assertTrue((boolean)this.testMap.contains((Object)this.map.elements().nextElement()));
        this.assertNoEvents();
    }

    public void testContainsKey() {
        IndirectMapTestAPI.assertTrue((boolean)this.testMap.containsKey((Object)this.map.keys().nextElement()));
        this.assertNoEvents();
    }

    public void testContainsValue() {
        IndirectMapTestAPI.assertTrue((boolean)this.testMap.containsValue((Object)this.map.elements().nextElement()));
        this.assertNoEvents();
    }

    public void testElements() {
        IndirectMapTestAPI.assertTrue((String)"Map Does not contain elements from test", (boolean)this.map.contains(this.testMap.elements().nextElement()));
        this.assertNoEvents();
    }

    public void testEntrySet() {
        IndirectMapTestAPI.assertEquals(this.map.entrySet(), (Object)this.testMap.entrySet());
        this.assertNoEvents();
    }

    public void testEntrySetAdd() {
        Set<Map.Entry<String, String>> entrySet = this.map.entrySet();
        Set testEntrySet = this.testMap.entrySet();
        UnsupportedOperationException uoe = null;
        try {
            entrySet.add(new MapEntry<String, String>("sampleKey", "sampleValue"));
        }
        catch (UnsupportedOperationException ex) {
            uoe = ex;
        }
        IndirectMapTestAPI.assertNotNull((Object)uoe);
        try {
            testEntrySet.add(new MapEntry<String, String>("sampleKey", "sampleValue"));
            IndirectMapTestAPI.fail((String)"should throw UnsupportedOperationException");
        }
        catch (UnsupportedOperationException ex) {
            IndirectMapTestAPI.assertEquals(uoe.getClass(), ex.getClass());
            IndirectMapTestAPI.assertEquals((String)uoe.getMessage(), (String)ex.getMessage());
        }
        IndirectMapTestAPI.assertEquals(this.map, this.testMap);
        this.assertNoEvents();
    }

    public void testEntrySetAddAll() {
        HashSet<MapEntry<String, String>> collection = new HashSet<MapEntry<String, String>>();
        collection.add(new MapEntry<String, String>("sampleKey1", "sampleValue1"));
        collection.add(new MapEntry<String, String>("sampleKey2", "sampleValue2"));
        Set<Map.Entry<String, String>> entrySet = this.map.entrySet();
        Set testEntrySet = this.testMap.entrySet();
        UnsupportedOperationException uoe = null;
        try {
            entrySet.addAll(collection);
        }
        catch (UnsupportedOperationException ex) {
            uoe = ex;
        }
        IndirectMapTestAPI.assertNotNull((Object)uoe);
        try {
            testEntrySet.addAll(collection);
            IndirectMapTestAPI.fail((String)"should throw UnsupportedOperationException");
        }
        catch (UnsupportedOperationException ex) {
            IndirectMapTestAPI.assertEquals(uoe.getClass(), ex.getClass());
            IndirectMapTestAPI.assertEquals((String)uoe.getMessage(), (String)ex.getMessage());
        }
        IndirectMapTestAPI.assertEquals(this.map, this.testMap);
        this.assertNoEvents();
    }

    public void testEntrySetClear() {
        Set<Map.Entry<String, String>> entrySet = this.map.entrySet();
        Set testEntrySet = this.testMap.entrySet();
        entrySet.clear();
        testEntrySet.clear();
        IndirectMapTestAPI.assertEquals(this.map, this.testMap);
        IndirectMapTestAPI.assertNull((Object)this.testMap.get((Object)"one"));
        this.assertRemoveEvents(10);
    }

    public void testEntrySetSize() {
        Set<Map.Entry<String, String>> entrySet = this.map.entrySet();
        Set testEntrySet = this.testMap.entrySet();
        IndirectMapTestAPI.assertEquals(this.map, this.testMap);
        IndirectMapTestAPI.assertEquals((int)entrySet.size(), (int)testEntrySet.size());
        this.assertNoEvents();
    }

    public void testEntrySetRemove() {
        Set<Map.Entry<String, String>> entrySet = this.map.entrySet();
        Set testEntrySet = this.testMap.entrySet();
        Map.Entry<String, String> toRemove = null;
        for (Map.Entry<String, String> next : entrySet) {
            if (!"one".equals(next.getKey())) continue;
            toRemove = next;
            break;
        }
        boolean result1 = entrySet.remove(toRemove);
        boolean result2 = testEntrySet.remove(toRemove);
        IndirectMapTestAPI.assertEquals(this.map, this.testMap);
        IndirectMapTestAPI.assertEquals((boolean)result1, (boolean)result2);
        IndirectMapTestAPI.assertNull((Object)this.testMap.get((Object)"one"));
        this.assertRemoveEvents(1);
    }

    public void testEntrySetRemoveAll() {
        Set<Map.Entry<String, String>> entrySet = this.map.entrySet();
        Set testEntrySet = this.testMap.entrySet();
        HashSet<Map.Entry<String, String>> toRemove = new HashSet<Map.Entry<String, String>>();
        for (Map.Entry<String, String> next : entrySet) {
            if ("one".equals(next.getKey()) || "two".equals(next.getKey())) {
                toRemove.add(next);
            }
            if (toRemove.size() != 2) continue;
            break;
        }
        boolean result1 = entrySet.removeAll(toRemove);
        boolean result2 = testEntrySet.removeAll(toRemove);
        IndirectMapTestAPI.assertEquals(this.map, this.testMap);
        IndirectMapTestAPI.assertEquals((boolean)result1, (boolean)result2);
        IndirectMapTestAPI.assertNull((Object)this.testMap.get((Object)"one"));
        this.assertRemoveEvents(2);
    }

    public void testEntrySetRemoveIf() {
        Set<Map.Entry<String, String>> entrySet = this.map.entrySet();
        Set testEntrySet = this.testMap.entrySet();
        boolean result1 = entrySet.removeIf(entry -> "one".equals(entry.getKey()));
        boolean result2 = testEntrySet.removeIf(entry -> "one".equals(entry.getKey()));
        IndirectMapTestAPI.assertEquals(this.map, this.testMap);
        IndirectMapTestAPI.assertEquals((boolean)result1, (boolean)result2);
        IndirectMapTestAPI.assertNull((Object)this.testMap.get((Object)"one"));
        this.assertRemoveEvents(1);
    }

    public void testEntrySetRetainAll() {
        Set<Map.Entry<String, String>> entrySet = this.map.entrySet();
        Set testEntrySet = this.testMap.entrySet();
        HashSet<Map.Entry<String, String>> toRetain = new HashSet<Map.Entry<String, String>>();
        for (Map.Entry<String, String> next : entrySet) {
            if ("one".equals(next.getKey()) || "two".equals(next.getKey())) {
                toRetain.add(next);
            }
            if (toRetain.size() != 2) continue;
            break;
        }
        boolean result1 = entrySet.retainAll(toRetain);
        boolean result2 = testEntrySet.retainAll(toRetain);
        IndirectMapTestAPI.assertEquals(this.map, this.testMap);
        IndirectMapTestAPI.assertNotNull((Object)this.testMap.get((Object)"one"));
        IndirectMapTestAPI.assertEquals((boolean)result1, (boolean)result2);
        IndirectMapTestAPI.assertNull((Object)this.testMap.get((Object)"six"));
        this.assertRemoveEvents(8);
    }

    public void testEquals() {
        IndirectMapTestAPI.assertFalse((this.testMap == this.map ? 1 : 0) != 0);
        IndirectMapTestAPI.assertTrue((boolean)this.testMap.equals(this.map));
        this.assertNoEvents();
    }

    public void testGet() {
        IndirectMapTestAPI.assertEquals((String)this.map.get("six"), (String)((String)this.testMap.get((Object)"six")));
        this.assertNoEvents();
    }

    public void testHashCode() {
        IndirectMapTestAPI.assertEquals((int)this.map.hashCode(), (int)this.testMap.hashCode());
        this.assertNoEvents();
    }

    public void testIsEmpty() {
        IndirectMapTestAPI.assertTrue((!this.testMap.isEmpty() ? 1 : 0) != 0);
        this.assertNoEvents();
    }

    public void testKeys() {
        IndirectMapTestAPI.assertFalse((String)"Map Does not contain keys from test", (boolean)this.map.contains(this.testMap.keys().nextElement()));
        this.assertNoEvents();
    }

    public void testKeySet() {
        IndirectMapTestAPI.assertEquals(this.map.entrySet(), (Object)this.testMap.entrySet());
        this.assertNoEvents();
    }

    public void testKeySetAdd() {
        Set<String> keySet = this.map.keySet();
        Set testKeySet = this.testMap.keySet();
        UnsupportedOperationException uoe = null;
        try {
            keySet.add("newKey");
        }
        catch (UnsupportedOperationException ex) {
            uoe = ex;
        }
        IndirectMapTestAPI.assertNotNull((Object)uoe);
        try {
            testKeySet.add("newKey");
            IndirectMapTestAPI.fail((String)"should throw UnsupportedOperationException");
        }
        catch (UnsupportedOperationException ex) {
            IndirectMapTestAPI.assertEquals(uoe.getClass(), ex.getClass());
            IndirectMapTestAPI.assertEquals((String)uoe.getMessage(), (String)ex.getMessage());
        }
        IndirectMapTestAPI.assertEquals(this.map, this.testMap);
        this.assertNoEvents();
    }

    public void testKeySetAddAll() {
        HashSet<String> collection = new HashSet<String>();
        collection.add("sampleKey1");
        collection.add("sampleKey2");
        Set<String> keySet = this.map.keySet();
        Set testKeySet = this.testMap.keySet();
        UnsupportedOperationException uoe = null;
        try {
            keySet.addAll(collection);
        }
        catch (UnsupportedOperationException ex) {
            uoe = ex;
        }
        IndirectMapTestAPI.assertNotNull((Object)uoe);
        try {
            testKeySet.addAll(collection);
            IndirectMapTestAPI.fail((String)"should throw UnsupportedOperationException");
        }
        catch (UnsupportedOperationException ex) {
            IndirectMapTestAPI.assertEquals(uoe.getClass(), ex.getClass());
            IndirectMapTestAPI.assertEquals((String)uoe.getMessage(), (String)ex.getMessage());
        }
        IndirectMapTestAPI.assertEquals(this.map, this.testMap);
        this.assertNoEvents();
    }

    public void testKeySetClear() {
        Set<String> keySet = this.map.keySet();
        Set testKeySet = this.testMap.keySet();
        keySet.clear();
        testKeySet.clear();
        IndirectMapTestAPI.assertEquals(this.map, this.testMap);
        IndirectMapTestAPI.assertNull((Object)this.testMap.get((Object)"one"));
        this.assertRemoveEvents(10);
    }

    public void testKeySetSize() {
        Set<String> keySet = this.map.keySet();
        Set testKeySet = this.testMap.keySet();
        IndirectMapTestAPI.assertEquals(this.map, this.testMap);
        IndirectMapTestAPI.assertEquals((int)keySet.size(), (int)testKeySet.size());
        this.assertNoEvents();
    }

    public void testKeySetRemove() {
        Set<String> keySet = this.map.keySet();
        Set testKeySet = this.testMap.keySet();
        boolean result1 = keySet.remove("one");
        boolean result2 = testKeySet.remove("one");
        IndirectMapTestAPI.assertEquals(this.map, this.testMap);
        IndirectMapTestAPI.assertEquals((boolean)result1, (boolean)result2);
        IndirectMapTestAPI.assertNull((Object)this.testMap.get((Object)"one"));
        this.assertRemoveEvents(1);
    }

    public void testKeySetRemoveAll() {
        Set<String> keySet = this.map.keySet();
        Set testKeySet = this.testMap.keySet();
        HashSet<String> toRemove = new HashSet<String>();
        toRemove.add("one");
        toRemove.add("two");
        boolean result1 = keySet.removeAll(toRemove);
        boolean result2 = testKeySet.removeAll(toRemove);
        IndirectMapTestAPI.assertEquals(this.map, this.testMap);
        IndirectMapTestAPI.assertEquals((boolean)result1, (boolean)result2);
        IndirectMapTestAPI.assertNull((Object)this.testMap.get((Object)"one"));
        this.assertRemoveEvents(2);
    }

    public void testKeySetRemoveIf() {
        Set<String> keySet = this.map.keySet();
        Set testKeySet = this.testMap.keySet();
        boolean result1 = keySet.removeIf(key -> key.startsWith("s"));
        boolean result2 = testKeySet.removeIf(key -> key.startsWith("s"));
        IndirectMapTestAPI.assertEquals(this.map, this.testMap);
        IndirectMapTestAPI.assertEquals((boolean)result1, (boolean)result2);
        IndirectMapTestAPI.assertNull((Object)this.testMap.get((Object)"six"));
        this.assertRemoveEvents(2);
    }

    public void testKeySetRetainAll() {
        Set<String> keySet = this.map.keySet();
        Set testKeySet = this.testMap.keySet();
        HashSet<String> toRetain = new HashSet<String>();
        toRetain.add("one");
        toRetain.add("two");
        boolean result1 = keySet.retainAll(toRetain);
        boolean result2 = testKeySet.retainAll(toRetain);
        IndirectMapTestAPI.assertEquals(this.map, this.testMap);
        IndirectMapTestAPI.assertNotNull((Object)this.testMap.get((Object)"one"));
        IndirectMapTestAPI.assertEquals((boolean)result1, (boolean)result2);
        IndirectMapTestAPI.assertNull((Object)this.testMap.get((Object)"six"));
        this.assertRemoveEvents(8);
    }

    public void testPut() {
        String key = "foo";
        String value = "bar";
        String result1 = this.map.put(key, value);
        String result2 = (String)this.testMap.put((Object)key, (Object)value);
        IndirectMapTestAPI.assertEquals(this.map, this.testMap);
        IndirectMapTestAPI.assertTrue((boolean)this.testMap.containsKey((Object)key));
        IndirectMapTestAPI.assertTrue((boolean)this.testMap.contains((Object)value));
        IndirectMapTestAPI.assertEquals((String)result1, (String)result2);
        this.assertAddEvents(1);
    }

    public void testPutAll() {
        Hashtable<String, String> temp = new Hashtable<String, String>();
        temp.put("foo", "bar");
        temp.put("sna", "fu");
        this.map.putAll(temp);
        this.testMap.putAll(temp);
        IndirectMapTestAPI.assertEquals(this.map, this.testMap);
        Enumeration<Object> stream = temp.keys();
        while (stream.hasMoreElements()) {
            IndirectMapTestAPI.assertTrue((boolean)this.testMap.containsKey(stream.nextElement()));
        }
        stream = temp.elements();
        while (stream.hasMoreElements()) {
            IndirectMapTestAPI.assertTrue((boolean)this.testMap.contains(stream.nextElement()));
        }
        this.assertAddEvents(2);
    }

    public void testRemove() {
        String temp = "one";
        String result1 = this.map.remove(temp);
        String result2 = (String)this.testMap.remove((Object)temp);
        IndirectMapTestAPI.assertEquals(this.map, this.testMap);
        IndirectMapTestAPI.assertEquals((String)result1, (String)result2);
        IndirectMapTestAPI.assertNotNull((Object)result2);
        IndirectMapTestAPI.assertTrue((!this.testMap.containsKey((Object)temp) ? 1 : 0) != 0);
        this.assertRemoveEvents(1);
    }

    public void testSize() {
        IndirectMapTestAPI.assertEquals((int)this.map.size(), (int)this.testMap.size());
        this.assertNoEvents();
    }

    public void testValues() {
        IndirectMapTestAPI.assertEquals((int)this.map.size(), (int)this.testMap.values().size());
        Iterator stream = this.testMap.values().iterator();
        while (stream.hasNext()) {
            IndirectMapTestAPI.assertTrue((boolean)this.map.contains(stream.next()));
        }
        this.map.values().removeAll(this.testMap.values());
        IndirectMapTestAPI.assertTrue((boolean)this.map.values().isEmpty());
        this.assertNoEvents();
    }

    public void testValuesAdd() {
        Collection<String> keySet = this.map.values();
        Collection testKeySet = this.testMap.values();
        UnsupportedOperationException uoe = null;
        try {
            keySet.add("newValue");
        }
        catch (UnsupportedOperationException ex) {
            uoe = ex;
        }
        IndirectMapTestAPI.assertNotNull((Object)uoe);
        try {
            testKeySet.add("newValue");
            IndirectMapTestAPI.fail((String)"should throw UnsupportedOperationException");
        }
        catch (UnsupportedOperationException ex) {
            IndirectMapTestAPI.assertEquals(uoe.getClass(), ex.getClass());
            IndirectMapTestAPI.assertEquals((String)uoe.getMessage(), (String)ex.getMessage());
        }
        IndirectMapTestAPI.assertEquals(this.map, this.testMap);
        this.assertNoEvents();
    }

    public void testValuesAddAll() {
        HashSet<String> collection = new HashSet<String>();
        collection.add("newValue1");
        collection.add("newValue2");
        Collection<String> keySet = this.map.values();
        Collection testKeySet = this.testMap.values();
        UnsupportedOperationException uoe = null;
        try {
            keySet.addAll(collection);
        }
        catch (UnsupportedOperationException ex) {
            uoe = ex;
        }
        IndirectMapTestAPI.assertNotNull((Object)uoe);
        try {
            testKeySet.addAll(collection);
            IndirectMapTestAPI.fail((String)"should throw UnsupportedOperationException");
        }
        catch (UnsupportedOperationException ex) {
            IndirectMapTestAPI.assertEquals(uoe.getClass(), ex.getClass());
            IndirectMapTestAPI.assertEquals((String)uoe.getMessage(), (String)ex.getMessage());
        }
        IndirectMapTestAPI.assertEquals(this.map, this.testMap);
        this.assertNoEvents();
    }

    public void testValuesClear() {
        Collection<String> keySet = this.map.values();
        Collection testKeySet = this.testMap.values();
        keySet.clear();
        testKeySet.clear();
        IndirectMapTestAPI.assertEquals(this.map, this.testMap);
        IndirectMapTestAPI.assertNull((Object)this.testMap.get((Object)"one"));
        this.assertRemoveEvents(10);
    }

    public void testValuesSize() {
        Collection<String> keySet = this.map.values();
        Collection testKeySet = this.testMap.values();
        IndirectMapTestAPI.assertEquals(this.map, this.testMap);
        IndirectMapTestAPI.assertEquals((int)keySet.size(), (int)testKeySet.size());
        this.assertNoEvents();
    }

    public void testValuesRemove() {
        Collection<String> keySet = this.map.values();
        Collection testKeySet = this.testMap.values();
        boolean result1 = keySet.remove("111");
        boolean result2 = testKeySet.remove("111");
        IndirectMapTestAPI.assertEquals(this.map, this.testMap);
        IndirectMapTestAPI.assertEquals((boolean)result1, (boolean)result2);
        IndirectMapTestAPI.assertNull((Object)this.testMap.get((Object)"one"));
        this.assertRemoveEvents(1);
    }

    public void testValuesRemoveAll() {
        Collection<String> keySet = this.map.values();
        Collection testKeySet = this.testMap.values();
        HashSet<String> toRemove = new HashSet<String>();
        toRemove.add("111");
        toRemove.add("222");
        boolean result1 = keySet.removeAll(toRemove);
        boolean result2 = testKeySet.removeAll(toRemove);
        IndirectMapTestAPI.assertEquals(this.map, this.testMap);
        IndirectMapTestAPI.assertEquals((boolean)result1, (boolean)result2);
        IndirectMapTestAPI.assertNull((Object)this.testMap.get((Object)"one"));
        this.assertRemoveEvents(2);
    }

    public void testValuesRemoveIf() {
        Collection<String> keySet = this.map.values();
        Collection testKeySet = this.testMap.values();
        boolean result1 = keySet.removeIf(key -> key.startsWith("2"));
        boolean result2 = testKeySet.removeIf(key -> key.startsWith("2"));
        IndirectMapTestAPI.assertEquals(this.map, this.testMap);
        IndirectMapTestAPI.assertEquals((boolean)result1, (boolean)result2);
        IndirectMapTestAPI.assertNull((Object)this.testMap.get((Object)"two"));
        this.assertRemoveEvents(1);
    }

    public void testValueRetainAll() {
        Collection<String> keySet = this.map.values();
        Collection testKeySet = this.testMap.values();
        HashSet<String> toRetain = new HashSet<String>();
        toRetain.add("111");
        toRetain.add("222");
        boolean result1 = keySet.retainAll(toRetain);
        boolean result2 = testKeySet.retainAll(toRetain);
        IndirectMapTestAPI.assertEquals(this.map, this.testMap);
        IndirectMapTestAPI.assertNotNull((Object)this.testMap.get((Object)"one"));
        IndirectMapTestAPI.assertEquals((boolean)result1, (boolean)result2);
        IndirectMapTestAPI.assertNull((Object)this.testMap.get((Object)"six"));
        this.assertRemoveEvents(8);
    }

    public void testReplace() {
        IndirectMapTestAPI.assertEquals(this.map, this.testMap);
        Object o = this.testMap.replace((Object)"one", (Object)"1");
        IndirectMapTestAPI.assertEquals((Object)this.map.replace("one", "1"), (Object)o);
        IndirectMapTestAPI.assertNotNull((String)"Should return value", (Object)o);
        IndirectMapTestAPI.assertEquals((Object)"111", (Object)o);
        IndirectMapTestAPI.assertEquals((String)"1", (String)((String)this.testMap.get((Object)"one")));
        IndirectMapTestAPI.assertEquals(this.map, this.testMap);
        this.assertRemoveAddEvents(1);
        IndirectMapTestAPI.assertNull((Object)this.map.replace("blablablabla", "whatever"));
        IndirectMapTestAPI.assertNull((Object)this.testMap.replace((Object)"blablablabla", (Object)"whatever"));
        IndirectMapTestAPI.assertEquals(this.map, this.testMap);
        this.assertRemoveAddEvents(1);
    }

    public void testReplaceWithDefault() {
        IndirectMapTestAPI.assertEquals((String)"111", (String)((String)this.testMap.get((Object)"one")));
        Boolean o = this.testMap.replace((Object)"one", (Object)"1", (Object)"1234");
        IndirectMapTestAPI.assertEquals((Object)this.map.replace("one", "1", "1234"), (Object)o);
        IndirectMapTestAPI.assertFalse((String)"Should return false", (boolean)o);
        IndirectMapTestAPI.assertFalse((String)"Should not have '1234'", (boolean)this.testMap.containsValue((Object)"1234"));
        IndirectMapTestAPI.assertEquals(this.map, this.testMap);
        this.assertNoEvents();
        IndirectMapTestAPI.assertEquals((String)"111", (String)((String)this.testMap.get((Object)"one")));
        o = this.testMap.replace((Object)"one", (Object)"111", (Object)"1234");
        IndirectMapTestAPI.assertEquals((Object)this.map.replace("one", "111", "1234"), (Object)o);
        IndirectMapTestAPI.assertTrue((String)"Should return true", (boolean)o);
        IndirectMapTestAPI.assertEquals((String)"1234", (String)((String)this.testMap.get((Object)"one")));
        IndirectMapTestAPI.assertEquals(this.map, this.testMap);
        this.assertRemoveAddEvents(1);
    }

    public void testGetOrDefault() {
        IndirectMapTestAPI.assertFalse((boolean)this.testMap.containsKey((Object)"temp"));
        Object o = this.testMap.getOrDefault((Object)"temp", (Object)"1234");
        IndirectMapTestAPI.assertNotNull((String)"Should return value", (Object)o);
        IndirectMapTestAPI.assertEquals((Object)"1234", (Object)o);
        IndirectMapTestAPI.assertTrue((boolean)this.testMap.containsKey((Object)"one"));
        o = this.testMap.getOrDefault((Object)"one", (Object)"5678");
        IndirectMapTestAPI.assertNotNull((String)"Should return value", (Object)o);
        IndirectMapTestAPI.assertEquals((Object)"111", (Object)o);
        this.assertNoEvents();
    }

    public void testPutIfAbsent() {
        IndirectMapTestAPI.assertFalse((boolean)this.testMap.containsKey((Object)"temp"));
        Object o = this.testMap.putIfAbsent((Object)"temp", (Object)"1234");
        IndirectMapTestAPI.assertNull((String)"Should return null", (Object)o);
        this.assertAddEvents(1);
        IndirectMapTestAPI.assertTrue((boolean)this.testMap.containsKey((Object)"temp"));
        o = this.testMap.putIfAbsent((Object)"temp", (Object)"5678");
        IndirectMapTestAPI.assertNotNull((String)"Should return value", (Object)o);
        IndirectMapTestAPI.assertEquals((Object)"1234", (Object)o);
        this.assertAddEvents(1);
    }

    public void testRemoveTwoArgs() {
        IndirectMapTestAPI.assertEquals((String)"111", (String)((String)this.testMap.get((Object)"one")));
        Boolean o = this.testMap.remove((Object)"one", (Object)"1234");
        IndirectMapTestAPI.assertFalse((String)"Should return false", (boolean)o);
        this.assertNoEvents();
        IndirectMapTestAPI.assertEquals((String)"111", (String)((String)this.testMap.get((Object)"one")));
        o = this.testMap.remove((Object)"one", (Object)"111");
        IndirectMapTestAPI.assertTrue((String)"Should return true", (boolean)o);
        IndirectMapTestAPI.assertNull((Object)this.testMap.get((Object)"one"));
        this.assertRemoveEvents(1);
    }

    public void testForEach() {
        Vector v1 = new Vector();
        Vector v2 = new Vector();
        this.map.forEach((k, v) -> {
            v1.add(k);
            v1.add(v);
        });
        this.testMap.forEach((k, v) -> {
            v2.add(k);
            v2.add(v);
        });
        this.assertUnorderedElementsEqual(v1, v2);
        IndirectMapTestAPI.assertEquals(this.map, this.testMap);
        this.assertNoEvents();
    }

    public void testReplaceAll() {
        IndirectMapTestAPI.assertEquals(this.map, this.testMap);
        this.map.replaceAll((k, v) -> {
            v = v + "sufix";
            return v;
        });
        this.testMap.replaceAll((k, v) -> {
            v = v + "sufix";
            return v;
        });
        IndirectMapTestAPI.assertEquals(this.map, this.testMap);
        this.assertRemoveAddEvents(this.testMap.size());
    }

    public void testCompute() {
        IndirectMapTestAPI.assertEquals(this.map, this.testMap);
        String s1 = this.map.compute("one", (k, v) -> {
            v = v + "suffix";
            return v;
        });
        String s2 = (String)this.testMap.compute((Object)"one", (k, v) -> {
            v = v + "suffix";
            return v;
        });
        IndirectMapTestAPI.assertEquals((String)s1, (String)s2);
        IndirectMapTestAPI.assertEquals(this.map, this.testMap);
        IndirectMapTestAPI.assertEquals((String)"111suffix", (String)((String)this.testMap.get((Object)"one")));
        this.assertRemoveAddEvents(1);
    }

    public void testCompute2() {
        IndirectMapTestAPI.assertEquals(this.map, this.testMap);
        String s1 = this.map.compute("notExist", (k, v) -> {
            v = v + "suffix";
            return v;
        });
        String s2 = (String)this.testMap.compute((Object)"notExist", (k, v) -> {
            v = v + "suffix";
            return v;
        });
        IndirectMapTestAPI.assertEquals((String)s1, (String)s2);
        IndirectMapTestAPI.assertEquals(this.map, this.testMap);
        IndirectMapTestAPI.assertEquals((String)"nullsuffix", (String)((String)this.testMap.get((Object)"notExist")));
        this.assertAddEvents(1);
    }

    public void testComputeIfPresent() {
        IndirectMapTestAPI.assertEquals(this.map, this.testMap);
        String s1 = this.map.computeIfPresent("one", (k, v) -> {
            v = v + "suffix";
            return v;
        });
        String s2 = (String)this.testMap.computeIfPresent((Object)"one", (k, v) -> {
            v = v + "suffix";
            return v;
        });
        IndirectMapTestAPI.assertEquals((String)s1, (String)s2);
        IndirectMapTestAPI.assertEquals(this.map, this.testMap);
        IndirectMapTestAPI.assertEquals((String)"111suffix", (String)((String)this.testMap.get((Object)"one")));
        this.assertRemoveAddEvents(1);
    }

    public void testComputeIfPresent2() {
        IndirectMapTestAPI.assertEquals(this.map, this.testMap);
        String s1 = this.map.computeIfPresent("notExist", (k, v) -> {
            v = v + "suffix";
            return v;
        });
        String s2 = (String)this.testMap.computeIfPresent((Object)"notExist", (k, v) -> {
            v = v + "suffix";
            return v;
        });
        IndirectMapTestAPI.assertEquals((String)s1, (String)s2);
        IndirectMapTestAPI.assertEquals(this.map, this.testMap);
        IndirectMapTestAPI.assertNull((Object)this.testMap.get((Object)"notExist"));
        this.assertNoEvents();
    }

    public void testComputeIfAbsent() {
        IndirectMapTestAPI.assertEquals(this.map, this.testMap);
        String s1 = this.map.computeIfAbsent("one", k -> "newitem");
        String s2 = (String)this.testMap.computeIfAbsent((Object)"one", k -> "newitem");
        IndirectMapTestAPI.assertEquals((String)s1, (String)s2);
        IndirectMapTestAPI.assertEquals(this.map, this.testMap);
        IndirectMapTestAPI.assertEquals((String)"111", (String)((String)this.testMap.get((Object)"one")));
        this.assertNoEvents();
    }

    public void testComputeIfAbsent2() {
        IndirectMapTestAPI.assertEquals(this.map, this.testMap);
        String s1 = this.map.computeIfAbsent("notExist", k -> "newitem");
        String s2 = (String)this.testMap.computeIfAbsent((Object)"notExist", k -> "newitem");
        IndirectMapTestAPI.assertEquals((String)s1, (String)s2);
        IndirectMapTestAPI.assertEquals(this.map, this.testMap);
        this.assertAddEvents(1);
    }

    public void testMerge() {
        IndirectMapTestAPI.assertEquals(this.map, this.testMap);
        String s1 = this.map.merge("one", "custom", String::concat);
        String s2 = (String)this.testMap.merge((Object)"one", (Object)"custom", String::concat);
        IndirectMapTestAPI.assertEquals((String)s1, (String)s2);
        IndirectMapTestAPI.assertEquals(this.map, this.testMap);
        IndirectMapTestAPI.assertEquals((String)"111custom", (String)((String)this.testMap.get((Object)"one")));
        this.assertRemoveAddEvents(1);
    }

    public void testMerge2() {
        IndirectMapTestAPI.assertEquals(this.map, this.testMap);
        String s1 = this.map.merge("notExist", "custom", String::concat);
        String s2 = (String)this.testMap.merge((Object)"notExist", (Object)"custom", String::concat);
        IndirectMapTestAPI.assertEquals((String)s1, (String)s2);
        IndirectMapTestAPI.assertEquals(this.map, this.testMap);
        IndirectMapTestAPI.assertEquals((String)"111", (String)((String)this.testMap.get((Object)"one")));
        this.assertAddEvents(1);
    }

    private void assertNoEvents() {
        if (this.useListener) {
            IndirectMapTestAPI.assertTrue((boolean)this.testMapLsn.events.isEmpty());
        }
    }

    private void assertAddEvents(int count) {
        if (this.useListener) {
            IndirectMapTestAPI.assertEquals((String)"events do not match", (int)count, (int)this.testMapLsn.events.size());
            for (MapChangeEvent cce : this.testMapLsn.events) {
                IndirectMapTestAPI.assertEquals((String)"expected add event", (int)0, (int)cce.getChangeType());
            }
        }
    }

    private void assertRemoveEvents(int count) {
        if (this.useListener) {
            IndirectMapTestAPI.assertEquals((String)"events do not match", (int)count, (int)this.testMapLsn.events.size());
            for (MapChangeEvent cce : this.testMapLsn.events) {
                IndirectMapTestAPI.assertEquals((String)"expected add event", (int)1, (int)cce.getChangeType());
            }
        }
    }

    private void assertRemoveAddEvents(int count) {
        if (this.useListener) {
            int totalEvents = count * 2;
            IndirectMapTestAPI.assertEquals((String)"events do not match", (int)totalEvents, (int)this.testMapLsn.events.size());
            int i = 0;
            while (i < totalEvents) {
                MapChangeEvent removeEvent = (MapChangeEvent)this.testMapLsn.events.get(i++);
                MapChangeEvent addEvent = (MapChangeEvent)this.testMapLsn.events.get(i++);
                IndirectMapTestAPI.assertEquals((String)"expected remove event", (int)1, (int)removeEvent.getChangeType());
                IndirectMapTestAPI.assertEquals((String)"expected add event", (int)0, (int)addEvent.getChangeType());
                IndirectMapTestAPI.assertFalse((String)("removed: '" + removeEvent.getNewValue() + "', new: '" + addEvent.getNewValue() + "'"), (boolean)removeEvent.getNewValue().equals(addEvent.getNewValue()));
            }
        }
    }

    private static final class MapEntry<K, V>
    implements Map.Entry<K, V> {
        private K key;
        private V value;

        public MapEntry(K key, V value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            this.value = value;
            return this.value;
        }
    }

    private static final class Listener
    implements PropertyChangeListener {
        private List<MapChangeEvent> events = new ArrayList<MapChangeEvent>();

        private Listener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.events.add((MapChangeEvent)evt);
        }
    }
}

