/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.sessionsxml;

import junit.framework.Test;
import org.eclipse.persistence.exceptions.EclipseLinkException;
import org.eclipse.persistence.exceptions.SessionLoaderException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.factories.SessionManager;
import org.eclipse.persistence.sessions.factories.XMLSessionConfigLoader;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.framework.TestSuite;
import org.eclipse.persistence.testing.tests.validation.ExceptionTest;

public class SessionsXMLValidationTest
extends ExceptionTest {
    private Session loadedSession = null;
    private String sessionName = null;
    private String sessionXmlFileName = null;

    public SessionsXMLValidationTest() {
    }

    public SessionsXMLValidationTest(EclipseLinkException expected) {
        this.expectedException = expected;
        this.sessionName = "test";
    }

    public static SessionsXMLValidationTest sessionXmlNotFound() {
        SessionsXMLValidationTest test = new SessionsXMLValidationTest((EclipseLinkException)((Object)ValidationException.noSessionsXMLFound((String)"SomeDumbName")));
        test.setName("Sessions.xml not found");
        test.setSessionXmlFileName("SomeDumbName");
        return test;
    }

    public static void addTestsTo(TestSuite theSuite) {
        theSuite.addTest((Test)SessionsXMLValidationTest.sessionXmlNotFound());
    }

    protected Session getLoadedSession() {
        return this.loadedSession;
    }

    protected String getSessionName() {
        return this.sessionName;
    }

    protected String getSessionXmlFileName() {
        return this.sessionXmlFileName;
    }

    public void test() throws Exception {
        if (this.getSessionXmlFileName() != null) {
            SessionManager testManager = new SessionManager();
            XMLSessionConfigLoader loader = new XMLSessionConfigLoader(this.getSessionXmlFileName());
            try {
                AbstractSession session = testManager.getSession(loader, this.getSessionName(), ((Object)((Object)this)).getClass().getClassLoader(), false, true);
                this.setLoadedSession((Session)session);
            }
            catch (EclipseLinkException exception) {
                this.caughtException = exception;
            }
        }
    }

    protected void setLoadedSession(Session loadedSession) {
        this.loadedSession = loadedSession;
    }

    public void setSessionName(String sessionName) {
        this.sessionName = sessionName;
    }

    public void setSessionXmlFileName(String newName) {
        this.sessionXmlFileName = newName;
    }

    @Override
    public void verify() {
        if (this.expectedException == null) {
            if (this.caughtException != null) {
                throw new TestErrorException("Session failed to load properly.  Caught: " + (Object)((Object)this.caughtException));
            }
            return;
        }
        super.verify();
        if (this.expectedException instanceof SessionLoaderException && ((SessionLoaderException)this.expectedException).getExceptionList().size() != ((SessionLoaderException)this.caughtException).getExceptionList().size()) {
            throw new TestErrorException("Incorrect number of exceptions caught:\nExpected:" + (Object)((Object)this.expectedException) + "\nCaught:" + (Object)((Object)this.caughtException));
        }
    }
}

