/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.queries;

import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.persistence.descriptors.WrapperPolicy;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.tests.queries.ConformResultsInUnitOfWorkTest;

public class ShouldRegisterResultsInUnitOfWorkTest
extends ConformResultsInUnitOfWorkTest {
    Employee newEmp;
    Employee deletedEmp;
    Employee registeredEmp;
    boolean descriptorSetting;

    public ShouldRegisterResultsInUnitOfWorkTest(boolean descriptorSetting) {
        this.setShouldUseWrapperPolicy(true);
        this.descriptorSetting = descriptorSetting;
        if (descriptorSetting) {
            this.setName("DescriptorShouldRegisterResultsInUnitOfWorkTest");
        }
    }

    @Override
    public void buildConformQuery() {
        this.conformedQuery = new ReadAllQuery(Employee.class);
        this.conformedQuery.conformResultsInUnitOfWork();
        if (!this.descriptorSetting) {
            this.conformedQuery.setShouldRegisterResultsInUnitOfWork(false);
        }
    }

    @Override
    public void prepareTest() {
        this.registeredEmp = (Employee)this.unitOfWork.readObject(Employee.class);
        ReadObjectQuery query = new ReadObjectQuery(Employee.class);
        ExpressionBuilder builder = new ExpressionBuilder();
        query.setSelectionCriteria(builder.notEqual((Object)this.registeredEmp));
        this.deletedEmp = (Employee)this.unitOfWork.executeQuery((DatabaseQuery)query);
        this.unitOfWork.deleteObject((Object)this.deletedEmp);
        if (this.descriptorSetting) {
            this.getSession().getDescriptor(Employee.class).setShouldRegisterResultsInUnitOfWork(false);
        }
    }

    @Override
    public void test() {
        this.result = this.unitOfWork.executeQuery((DatabaseQuery)this.conformedQuery);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void verify() {
        try {
            Vector registeredEmployees = this.unitOfWork.getIdentityMapAccessor().getAllFromIdentityMap(null, Employee.class, null, null);
            if (registeredEmployees.size() != 2) {
                throw new TestErrorException("Should be only two employees registered in UOW cache, not: " + registeredEmployees.size());
            }
            Vector employees = (Vector)this.result;
            if (employees.size() != 11) {
                throw new TestErrorException("11 employees should be returned by the query, not: " + employees.size());
            }
            WrapperPolicy policy = this.getSession().getDescriptor(Employee.class).getWrapperPolicy();
            UnitOfWorkImpl uow = (UnitOfWorkImpl)this.unitOfWork;
            Object unwrappedRegistered = policy.unwrapObject((Object)this.registeredEmp, (AbstractSession)uow);
            Object unwrappedDeleted = policy.unwrapObject((Object)this.deletedEmp, (AbstractSession)uow);
            Enumeration enumtr = employees.elements();
            while (enumtr.hasMoreElements()) {
                Object next = policy.unwrapObject(enumtr.nextElement(), (AbstractSession)uow);
                if (unwrappedRegistered == next) {
                    this.registeredEmp = null;
                    continue;
                }
                if (unwrappedDeleted != next) continue;
                this.deletedEmp = null;
            }
            registeredEmployees = this.unitOfWork.getIdentityMapAccessor().getAllFromIdentityMap(null, Employee.class, null, null);
            if (registeredEmployees.size() != 12) {
                throw new TestErrorException("Should now be 12 employees registered in UOW cache, not: " + registeredEmployees.size());
            }
            if (this.registeredEmp != null) {
                throw new TestErrorException("The registered employee was not included in the result.");
            }
            if (this.deletedEmp == null) {
                throw new TestErrorException("The deleted employee was included in the result.");
            }
        }
        finally {
            this.unitOfWork.release();
            this.newEmp = null;
            this.registeredEmp = null;
            this.deletedEmp = null;
        }
    }

    @Override
    public void reset() {
        if (this.descriptorSetting) {
            this.getSession().getDescriptor(Employee.class).setShouldRegisterResultsInUnitOfWork(true);
        }
        super.reset();
    }
}

