/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.employee;

import junit.framework.Test;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.queries.Call;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.queries.SQLCall;
import org.eclipse.persistence.testing.framework.InsertObjectTest;
import org.eclipse.persistence.testing.framework.ReadAllCallTest;
import org.eclipse.persistence.testing.framework.ReadAllCallWithOrderingTest;
import org.eclipse.persistence.testing.framework.ReadAllTest;
import org.eclipse.persistence.testing.framework.ReadObjectCallTest;
import org.eclipse.persistence.testing.framework.ReadObjectTest;
import org.eclipse.persistence.testing.framework.TestModel;
import org.eclipse.persistence.testing.framework.TestSuite;
import org.eclipse.persistence.testing.framework.UnitOfWorkBasicUpdateObjectTest;
import org.eclipse.persistence.testing.framework.WriteObjectTest;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.models.employee.domain.EmployeePopulator;
import org.eclipse.persistence.testing.models.employee.domain.LargeProject;
import org.eclipse.persistence.testing.models.employee.domain.Project;
import org.eclipse.persistence.testing.models.employee.domain.SmallProject;
import org.eclipse.persistence.testing.models.employee.relational.EmployeeSystem;
import org.eclipse.persistence.testing.tests.employee.AddDescriptorsTest;
import org.eclipse.persistence.testing.tests.employee.EmployeeDeleteTest;
import org.eclipse.persistence.testing.tests.employee.ProjectDeleteTest;
import org.eclipse.persistence.tools.schemaframework.PopulationManager;

public class EmployeeBasicTestModel
extends TestModel {
    public static junit.framework.TestSuite suite() {
        return new EmployeeBasicTestModel();
    }

    public EmployeeBasicTestModel() {
        this.setDescription("This model tests reading/writing/deleting using the employee demo.");
    }

    public EmployeeBasicTestModel(boolean isSRG) {
        this();
        this.isSRG = isSRG;
    }

    public void addRequiredSystems() {
        this.addRequiredSystem(new EmployeeSystem());
    }

    public void addTests() {
        this.addTest((Test)EmployeeBasicTestModel.getReadObjectTestSuite());
        this.addTest((Test)EmployeeBasicTestModel.getUpdateObjectTestSuite());
        this.addTest((Test)EmployeeBasicTestModel.getInsertObjectTestSuite());
        this.addTest((Test)EmployeeBasicTestModel.getDeleteObjectTestSuite());
        this.addTest((Test)EmployeeBasicTestModel.getReadAllTestSuite());
        this.addTest((Test)EmployeeBasicTestModel.getMiscTestSuite());
    }

    public void addSRGTests() {
        this.addTest((Test)EmployeeBasicTestModel.getSRGReadObjectTestSuite());
        this.addTest((Test)EmployeeBasicTestModel.getSRGUpdateObjectTestSuite());
        this.addTest((Test)EmployeeBasicTestModel.getSRGInsertObjectTestSuite());
        this.addTest((Test)EmployeeBasicTestModel.getSRGDeleteObjectTestSuite());
        this.addTest((Test)EmployeeBasicTestModel.getSRGReadAllTestSuite());
        this.addTest((Test)EmployeeBasicTestModel.getSRGMiscTestSuite());
    }

    public static TestSuite getDeleteObjectTestSuite() {
        TestSuite suite = EmployeeBasicTestModel.getSRGDeleteObjectTestSuite();
        return suite;
    }

    public static TestSuite getSRGDeleteObjectTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("EmployeeDeleteObjectTestSuite");
        suite.setDescription("This suite tests the deletion of each object in the employee demo.");
        Class<Employee> employeeClass = Employee.class;
        Class<LargeProject> largeProjectClass = LargeProject.class;
        Class<SmallProject> smallProjectClass = SmallProject.class;
        PopulationManager manager = PopulationManager.getDefaultManager();
        suite.addTest((Test)new EmployeeDeleteTest(manager.getObject(employeeClass, "0001")));
        suite.addTest((Test)new EmployeeDeleteTest(manager.getObject(employeeClass, "0002")));
        suite.addTest((Test)new EmployeeDeleteTest(manager.getObject(employeeClass, "0003")));
        suite.addTest((Test)new EmployeeDeleteTest(manager.getObject(employeeClass, "0004")));
        suite.addTest((Test)new EmployeeDeleteTest(manager.getObject(employeeClass, "0005")));
        suite.addTest((Test)new ProjectDeleteTest(manager.getObject(smallProjectClass, "0001")));
        suite.addTest((Test)new ProjectDeleteTest(manager.getObject(smallProjectClass, "0002")));
        suite.addTest((Test)new ProjectDeleteTest(manager.getObject(smallProjectClass, "0003")));
        suite.addTest((Test)new ProjectDeleteTest(manager.getObject(largeProjectClass, "0001")));
        suite.addTest((Test)new ProjectDeleteTest(manager.getObject(largeProjectClass, "0002")));
        suite.addTest((Test)new ProjectDeleteTest(manager.getObject(largeProjectClass, "0003")));
        return suite;
    }

    public static TestSuite getInsertObjectTestSuite() {
        TestSuite suite = EmployeeBasicTestModel.getSRGInsertObjectTestSuite();
        return suite;
    }

    public static TestSuite getSRGInsertObjectTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("EmployeeInsertObjectTestSuite");
        suite.setDescription("This suite tests the insertion of each object in the employee demo.");
        EmployeePopulator system = new EmployeePopulator();
        suite.addTest((Test)new InsertObjectTest((Object)system.basicEmployeeExample1()));
        suite.addTest((Test)new InsertObjectTest((Object)system.basicEmployeeExample2()));
        suite.addTest((Test)new InsertObjectTest((Object)system.basicEmployeeExample3()));
        suite.addTest((Test)new InsertObjectTest((Object)system.basicEmployeeExample4()));
        suite.addTest((Test)new InsertObjectTest((Object)system.basicEmployeeExample5()));
        suite.addTest((Test)new InsertObjectTest((Object)system.basicSmallProjectExample1()));
        suite.addTest((Test)new InsertObjectTest((Object)system.basicSmallProjectExample2()));
        suite.addTest((Test)new InsertObjectTest((Object)system.basicSmallProjectExample3()));
        suite.addTest((Test)new InsertObjectTest((Object)system.basicLargeProjectExample1()));
        suite.addTest((Test)new InsertObjectTest((Object)system.basicLargeProjectExample2()));
        suite.addTest((Test)new InsertObjectTest((Object)system.basicLargeProjectExample3()));
        return suite;
    }

    public static TestSuite getReadAllTestSuite() {
        TestSuite suite = EmployeeBasicTestModel.getSRGReadAllTestSuite();
        Expression orderBy = new ExpressionBuilder().get("firstName").ascending();
        SQLCall call = new SQLCall("SELECT t0.VERSION, t1.EMP_ID, t0.L_NAME, t0.F_NAME, t1.SALARY, t0.EMP_ID, t0.GENDER, t0.END_DATE, t0.START_DATE, t0.MANAGER_ID, t0.ADDR_ID FROM EMPLOYEE t0, SALARY t1 WHERE t1.EMP_ID = t0.EMP_ID");
        suite.addTest((Test)new ReadAllCallWithOrderingTest(Employee.class, 12, (Call)call, orderBy));
        return suite;
    }

    public static TestSuite getSRGReadAllTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("EmployeeReadAllTestSuite");
        suite.setDescription("This suite tests the reading of all the objects of each class in the employee demo.");
        suite.addTest((Test)new ReadAllTest(Employee.class, 12));
        suite.addTest((Test)new ReadAllTest(Project.class, 15));
        suite.addTest((Test)new ReadAllTest(LargeProject.class, 5));
        suite.addTest((Test)new ReadAllTest(SmallProject.class, 10));
        suite.addTest((Test)new ReadAllCallTest(Employee.class, 12, (Call)new SQLCall("SELECT  t0.VERSION, t1.EMP_ID, t0.L_NAME, t0.F_NAME, t1.SALARY, t0.EMP_ID, t0.GENDER, t0.END_DATE, t0.START_DATE, t0.MANAGER_ID, t0.ADDR_ID FROM EMPLOYEE t0, SALARY t1 WHERE t1.EMP_ID = t0.EMP_ID")));
        return suite;
    }

    public static TestSuite getReadObjectTestSuite() {
        TestSuite suite = EmployeeBasicTestModel.getSRGReadObjectTestSuite();
        return suite;
    }

    public static TestSuite getSRGReadObjectTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("EmployeeReadObjectTestSuite");
        suite.setDescription("This suite test the reading of each object in the employee demo.");
        Class<Employee> employeeClass = Employee.class;
        Class<LargeProject> largeProjectClass = LargeProject.class;
        Class<SmallProject> smallProjectClass = SmallProject.class;
        PopulationManager manager = PopulationManager.getDefaultManager();
        suite.addTest((Test)new ReadObjectTest(manager.getObject(employeeClass, "0001")));
        suite.addTest((Test)new ReadObjectTest(manager.getObject(employeeClass, "0002")));
        suite.addTest((Test)new ReadObjectTest(manager.getObject(employeeClass, "0003")));
        suite.addTest((Test)new ReadObjectTest(manager.getObject(employeeClass, "0004")));
        suite.addTest((Test)new ReadObjectTest(manager.getObject(employeeClass, "0005")));
        Employee employee = (Employee)manager.getObject(employeeClass, "0001");
        suite.addTest((Test)new ReadObjectCallTest(employeeClass, (Call)new SQLCall("SELECT t0.VERSION, t1.EMP_ID, t0.L_NAME, t0.F_NAME, t1.SALARY, t0.EMP_ID, t0.GENDER, t0.END_DATE, t0.START_DATE, t0.MANAGER_ID, t0.END_TIME, t0.START_TIME, t0.ADDR_ID FROM EMPLOYEE t0, SALARY t1 WHERE t1.EMP_ID = t0.EMP_ID AND t0.F_NAME = '" + employee.getFirstName() + "' AND t0.L_NAME = '" + employee.getLastName() + "'")));
        employee = (Employee)manager.getObject(employeeClass, "0002");
        suite.addTest((Test)new ReadObjectCallTest(employeeClass, (Call)new SQLCall("SELECT  t0.VERSION, t1.EMP_ID, t0.L_NAME, t0.F_NAME, t1.SALARY, t0.EMP_ID, t0.GENDER, t0.END_DATE, t0.START_DATE, t0.MANAGER_ID, t0.END_TIME, t0.START_TIME, t0.ADDR_ID FROM EMPLOYEE t0, SALARY t1 WHERE t1.EMP_ID = t0.EMP_ID AND t0.F_NAME = '" + employee.getFirstName() + "' AND t0.L_NAME = '" + employee.getLastName() + "'")));
        employee = (Employee)manager.getObject(employeeClass, "0003");
        suite.addTest((Test)new ReadObjectCallTest(employeeClass, (Call)new SQLCall("SELECT  t0.VERSION, t1.EMP_ID, t0.L_NAME, t0.F_NAME, t1.SALARY, t0.EMP_ID, t0.GENDER, t0.END_DATE, t0.START_DATE, t0.MANAGER_ID, t0.END_TIME, t0.START_TIME, t0.ADDR_ID FROM EMPLOYEE t0, SALARY t1 WHERE t1.EMP_ID = t0.EMP_ID AND t0.F_NAME = '" + employee.getFirstName() + "' AND t0.L_NAME = '" + employee.getLastName() + "'")));
        Project project = (Project)manager.getObject(largeProjectClass, "0001");
        ReadObjectTest test = new ReadObjectTest((Object)project);
        test.setQuery(new ReadObjectQuery(Project.class, new ExpressionBuilder().get("id").equal((Object)project.getId())));
        suite.addTest((Test)test);
        suite.addTest((Test)new ReadObjectTest(manager.getObject(smallProjectClass, "0001")));
        suite.addTest((Test)new ReadObjectTest(manager.getObject(smallProjectClass, "0002")));
        suite.addTest((Test)new ReadObjectTest(manager.getObject(smallProjectClass, "0003")));
        suite.addTest((Test)new ReadObjectTest(manager.getObject(largeProjectClass, "0001")));
        suite.addTest((Test)new ReadObjectTest(manager.getObject(largeProjectClass, "0002")));
        suite.addTest((Test)new ReadObjectTest(manager.getObject(largeProjectClass, "0003")));
        return suite;
    }

    public static TestSuite getUpdateObjectTestSuite() {
        TestSuite suite = EmployeeBasicTestModel.getSRGUpdateObjectTestSuite();
        return suite;
    }

    public static TestSuite getSRGUpdateObjectTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("EmployeeUpdateObjectTestSuite");
        suite.setDescription("This suite tests the updating of each object in the employee demo.");
        Class<Employee> employeeClass = Employee.class;
        Class<LargeProject> largeProjectClass = LargeProject.class;
        Class<SmallProject> smallProjectClass = SmallProject.class;
        PopulationManager manager = PopulationManager.getDefaultManager();
        suite.addTest((Test)new WriteObjectTest(manager.getObject(employeeClass, "0001")));
        suite.addTest((Test)new UnitOfWorkBasicUpdateObjectTest(manager.getObject(employeeClass, "0001")));
        suite.addTest((Test)new UnitOfWorkBasicUpdateObjectTest(manager.getObject(employeeClass, "0002")));
        suite.addTest((Test)new UnitOfWorkBasicUpdateObjectTest(manager.getObject(employeeClass, "0003")));
        suite.addTest((Test)new UnitOfWorkBasicUpdateObjectTest(manager.getObject(employeeClass, "0004")));
        suite.addTest((Test)new UnitOfWorkBasicUpdateObjectTest(manager.getObject(employeeClass, "0005")));
        suite.addTest((Test)new WriteObjectTest(manager.getObject(smallProjectClass, "0001")));
        suite.addTest((Test)new UnitOfWorkBasicUpdateObjectTest(manager.getObject(smallProjectClass, "0001")));
        suite.addTest((Test)new UnitOfWorkBasicUpdateObjectTest(manager.getObject(smallProjectClass, "0002")));
        suite.addTest((Test)new UnitOfWorkBasicUpdateObjectTest(manager.getObject(smallProjectClass, "0003")));
        suite.addTest((Test)new WriteObjectTest(manager.getObject(largeProjectClass, "0001")));
        suite.addTest((Test)new UnitOfWorkBasicUpdateObjectTest(manager.getObject(largeProjectClass, "0001")));
        suite.addTest((Test)new UnitOfWorkBasicUpdateObjectTest(manager.getObject(largeProjectClass, "0002")));
        suite.addTest((Test)new UnitOfWorkBasicUpdateObjectTest(manager.getObject(largeProjectClass, "0003")));
        return suite;
    }

    public static TestSuite getMiscTestSuite() {
        TestSuite suite = EmployeeBasicTestModel.getSRGMiscTestSuite();
        return suite;
    }

    public static TestSuite getSRGMiscTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("MiscellaneousTests");
        suite.addTest((Test)new AddDescriptorsTest());
        return suite;
    }
}

