/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.queries.report;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.persistence.exceptions.EclipseLinkException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReportQuery;
import org.eclipse.persistence.queries.ReportQueryResult;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.models.employee.domain.Project;

public class ParameterizedSubqueryTest
extends TestCase {
    protected EclipseLinkException exception;
    protected List<ReportQueryResult> results;
    protected BigDecimal employeeId;
    protected String projectName;
    protected ReportQuery queryToExecute;

    public ParameterizedSubqueryTest() {
        this.setDescription("Test using a Parameterized Subquery in a Report Query");
    }

    public void setup() {
        if (this.getSession().isRemoteSession()) {
            this.throwWarning("Report queries with objects are not supported on remote session.");
        }
        ExpressionBuilder newBuilder = new ExpressionBuilder();
        Expression newExpression = newBuilder.get("firstName").equal((Object)"John").and(newBuilder.get("lastName").equal((Object)"Way"));
        Employee emp = (Employee)this.getSession().readObject(Employee.class, newExpression);
        Project aProject = (Project)emp.getProjects().get(0);
        this.employeeId = emp.getId();
        this.projectName = aProject.getName();
        ExpressionBuilder builder = new ExpressionBuilder();
        ReportQuery reportQuery = new ReportQuery(Employee.class, builder);
        reportQuery.addArgument("employeeId");
        reportQuery.addArgument("projectName");
        Expression employeeExpression = builder.get("id").equal(builder.getParameter("employeeId"));
        ExpressionBuilder builder2 = new ExpressionBuilder();
        ReportQuery query2 = new ReportQuery(Employee.class, builder2);
        Expression projects = builder.anyOf("projects").get("name").equal(builder2.getParameter("projectName"));
        query2.addAttribute("EmployeeIdentifier", builder2.get("id"));
        query2.setSelectionCriteria(projects);
        HashMap<Expression, String> caseParameters = new HashMap<Expression, String>();
        caseParameters.put(builder.getParameter("employeeId").in(query2), "true");
        Expression caseExpression = builder.caseStatement(caseParameters, (Object)"false");
        reportQuery.setSelectionCriteria(employeeExpression);
        reportQuery.addAttribute("EmployeeOnProject", caseExpression);
        this.queryToExecute = reportQuery;
    }

    public void test() {
        try {
            ArrayList<Object> arguments = new ArrayList<Object>();
            arguments.add(this.employeeId);
            arguments.add(this.projectName);
            this.results = (List)this.getSession().executeQuery((DatabaseQuery)this.queryToExecute, arguments);
        }
        catch (EclipseLinkException ex) {
            this.exception = ex;
        }
    }

    public void verify() {
        if (this.exception != null) {
            throw new TestErrorException("An exception occurred executing a ReportQuery with a parameterized subquery", (Throwable)this.exception);
        }
        if (this.results == null || this.results.isEmpty()) {
            throw new TestErrorException("Unexpected error - no ReportQuery results returned");
        }
        ReportQueryResult reportResult = this.results.get(0);
        if (!"true".equals(reportResult.get("EmployeeOnProject"))) {
            throw new TestErrorException("Unexpected error - incorrect results returned: " + reportResult);
        }
    }
}

