/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.queries;

import java.util.List;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.framework.TestWarningException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;

public class GetTableGetFieldTest
extends TestCase {
    protected List employees;

    public GetTableGetFieldTest() {
        this.setDescription("Test using Expression getTable(\"x\").getField(\"y\")");
    }

    public void test() {
        ReadAllQuery query = new ReadAllQuery(Employee.class);
        ExpressionBuilder builder = query.getExpressionBuilder();
        Expression subExp = builder.get("address").get("city").equal((Object)"Ottawa").and(builder.getTable("EMPLOYEE").getField("L_NAME").equal((Object)"Way"));
        query.setSelectionCriteria(subExp);
        query.useDistinct();
        List emps = null;
        try {
            emps = (List)this.getSession().executeQuery((DatabaseQuery)query);
        }
        catch (NullPointerException e) {
            e.printStackTrace();
            emps = null;
        }
        this.setEmployees(emps);
    }

    public void verify() {
        if (this.getEmployees() == null || this.getEmployees().isEmpty()) {
            throw new TestErrorException("Failure. Employees read in is null / empty");
        }
        if (this.getEmployees().size() != 1) {
            throw new TestWarningException("Employee data on database is not consistent");
        }
        Employee employee = (Employee)this.getEmployees().get(0);
        if (!employee.getFirstName().equals("John") && !employee.getLastName().equals("Way")) {
            throw new TestWarningException("Expected employee John Way was not selected");
        }
    }

    public void reset() {
        this.setEmployees(null);
    }

    public List getEmployees() {
        return this.employees;
    }

    public void setEmployees(List employees) {
        this.employees = employees;
    }
}

