/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.feature;

import org.eclipse.persistence.testing.framework.InsertObjectTest;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.framework.TestWarningException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;

public class GermanUmlautsWriteTest
extends InsertObjectTest {
    boolean usesStringBindingOriginal;
    int stringBindingSizeOriginal;

    public GermanUmlautsWriteTest() {
        Employee employee = new Employee();
        char[] umlautsCharCodes = new char[]{'\u00f6', '\u00e4', '\u00fc', '\u00df'};
        employee.setFirstName(new String(umlautsCharCodes));
        this.originalObject = employee;
        this.setDescription("Verifies that 'some german Umlaut characters' are written correctly in case string binding is used");
    }

    protected void setup() {
        if (this.getSession().getPlatform().isTimesTen() || this.getSession().getPlatform().isSymfoware()) {
            throw new TestWarningException("This test is not supported on this platform.");
        }
        super.setup();
        this.usesStringBindingOriginal = this.getSession().getPlatform().usesStringBinding();
        if (!this.usesStringBindingOriginal) {
            this.getSession().getPlatform().setUsesStringBinding(true);
        }
        this.stringBindingSizeOriginal = this.getSession().getPlatform().getStringBindingSize();
        if (this.stringBindingSizeOriginal != 1) {
            this.getSession().getPlatform().setStringBindingSize(1);
        }
    }

    protected void test() {
        String strOriginal = ((Employee)this.originalObject).getFirstName();
        this.getSession().logMessage("original firstName = " + strOriginal + this.codes(strOriginal));
        super.test();
    }

    protected void verify() {
        try {
            super.verify();
        }
        catch (TestErrorException ex) {
            String strOriginal = ((Employee)this.originalObject).getFirstName();
            String strFromDatabase = ((Employee)this.objectFromDatabase).getFirstName();
            if (!strOriginal.equals(strFromDatabase)) {
                throw new TestErrorException("String read is " + strFromDatabase + this.codes(strFromDatabase) + " instead of expected " + strOriginal + this.codes(strOriginal));
            }
            throw ex;
        }
    }

    public void reset() {
        if (this.getSession().getPlatform().usesStringBinding() != this.usesStringBindingOriginal) {
            this.getSession().getPlatform().setUsesStringBinding(this.usesStringBindingOriginal);
        }
        if (this.getSession().getPlatform().getStringBindingSize() != this.stringBindingSizeOriginal) {
            this.getSession().getPlatform().setStringBindingSize(this.stringBindingSizeOriginal);
        }
        super.reset();
    }

    protected String codes(String str) {
        String strCodes = "(";
        for (int i = 0; i < str.length(); ++i) {
            if (i != 0) {
                strCodes = strCodes + ",";
            }
            char code = str.charAt(i);
            strCodes = strCodes + code;
        }
        strCodes = strCodes + ")";
        return strCodes;
    }
}

