/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.collections;

import java.math.BigDecimal;
import java.util.Collection;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.collections.Location;
import org.eclipse.persistence.testing.models.collections.Restaurant;

public class TreeSetComparatorTest
extends AutoVerifyTestCase {
    public UnitOfWork unitOfWork;
    private boolean m_exceptionCaught;

    public void reset() {
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        this.rollbackTransaction();
    }

    protected void setup() {
        this.m_exceptionCaught = false;
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        this.beginTransaction();
        UnitOfWork deleteUow = this.getSession().acquireUnitOfWork();
        deleteUow.deleteAllObjects((Collection)this.getSession().readAllObjects(Location.class));
        deleteUow.deleteAllObjects((Collection)this.getSession().readAllObjects(Restaurant.class));
        deleteUow.commit();
    }

    public void test() {
        try {
            UnitOfWork uow = this.getSession().acquireUnitOfWork();
            Restaurant restaurantClone = (Restaurant)uow.registerObject((Object)new Restaurant());
            restaurantClone.setName("Guy's XXX Diner");
            restaurantClone.setId(new BigDecimal(1));
            restaurantClone.getLocations2().add(Location.example1());
            restaurantClone.getLocations2().add(Location.example2());
            uow.commit();
        }
        catch (ClassCastException e) {
            this.m_exceptionCaught = true;
        }
    }

    public void verify() {
        if (this.m_exceptionCaught) {
            throw new TestErrorException("Class cast exception caught on TreeSet merge");
        }
    }
}

