/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.framework;

import java.io.IOException;
import java.io.Writer;
import java.lang.ref.WeakReference;
import javax.persistence.EntityManager;
import org.eclipse.persistence.exceptions.EclipseLinkException;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.platform.database.DatabasePlatform;
import org.eclipse.persistence.sessions.DatabaseLogin;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.SessionEventAdapter;
import org.eclipse.persistence.sessions.SessionEventListener;
import org.eclipse.persistence.sessions.server.Server;
import org.eclipse.persistence.sessions.server.ServerSession;
import org.eclipse.persistence.testing.framework.JDBCIsoLevelSwitchListener;
import org.eclipse.persistence.testing.framework.ResultInterface;
import org.eclipse.persistence.testing.framework.SybaseTransactionIsolationListener;
import org.eclipse.persistence.testing.framework.TestEntity;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.framework.TestExecutor;
import org.eclipse.persistence.testing.framework.TestProblemException;
import org.eclipse.persistence.testing.framework.TestResult;
import org.eclipse.persistence.testing.framework.TestResultsSummary;
import org.eclipse.persistence.testing.framework.TestSystem;
import org.eclipse.persistence.testing.framework.TestWarningException;
import org.eclipse.persistence.testing.framework.TransactionIsolationLevelSwitchListener;

public abstract class TestCase
extends junit.framework.TestCase
implements TestEntity {
    private String name;
    private TestResult testResult = new TestResult(this);
    private transient TestExecutor executor;
    private String description = "";
    private TestEntity container;
    private int nestedCounter = -1;
    private String indentationString;

    public TestCase() {
        this.setName(this.getClass().getName().substring(this.getClass().getName().lastIndexOf(46) + 1));
    }

    @Override
    public String getName() {
        if (super.getName() == null) {
            this.setName(this.name);
        }
        return super.getName();
    }

    public void setName(String name) {
        super.setName(name);
        this.name = name;
    }

    @Override
    public void appendTestResult(TestResultsSummary summary) {
        summary.appendTestCaseResult(this);
    }

    @Override
    public void computeNestedLevel() {
        TestEntity testContainer = this.getContainer();
        if (testContainer != null && testContainer.getNestedCounter() != -1) {
            this.setNestedCounter(testContainer.getNestedCounter() + 1);
        } else {
            this.incrementNestedCounter();
        }
    }

    public boolean compareObjects(Object source, Object target) {
        return this.getAbstractSession().compareObjects(source, target);
    }

    public boolean verifyDelete(Object object) {
        return this.getAbstractSession().verifyDelete(object);
    }

    @Override
    public Session defaultLogin() {
        return new TestSystem().login();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void execute(TestExecutor executor) {
        boolean executeFailed = false;
        this.setTestResult(new TestResult(this, "Passed"));
        this.setExecutor(executor);
        long startTime = System.currentTimeMillis();
        try {
            try {
                this.setUp();
            }
            catch (EclipseLinkException exception) {
                executeFailed = true;
                this.setTestException(exception);
                throw exception;
            }
            catch (Throwable exception) {
                executeFailed = true;
                TestProblemException problem = new TestProblemException("Problem in the setup method of the test: " + this.getName());
                problem.setInternalException(exception);
                this.setTestException(problem);
                throw problem;
            }
            try {
                this.executeTest();
                this.verify();
                return;
            }
            catch (EclipseLinkException exception) {
                executeFailed = true;
                if (this.getTestException() != null) return;
                this.setTestException(exception);
                throw exception;
            }
            catch (Throwable runtimeException) {
                executeFailed = true;
                TestErrorException topLinkException = new TestErrorException("Fatal error occurred.", runtimeException);
                if (this.getTestException() != null) return;
                this.setTestException(topLinkException);
                throw topLinkException;
            }
        }
        finally {
            block42: {
                try {
                    this.tearDown();
                }
                catch (EclipseLinkException exception) {
                    executeFailed = true;
                    if (this.getTestException() == null) {
                        this.setTestException(exception);
                        throw exception;
                    }
                }
                catch (Throwable exception) {
                    executeFailed = true;
                    TestProblemException problem = new TestProblemException("Problem in the reset method of the test");
                    problem.setInternalException(exception);
                    if (this.getTestException() == null) {
                        this.setTestException(problem);
                        throw problem;
                    }
                }
                finally {
                    long endTime = System.currentTimeMillis();
                    this.getTestResult().setTotalTime(endTime - startTime);
                    if (executeFailed && !this.isLocalTest()) {
                        this.cleanAfterExecuteFailed();
                    }
                    if (!this.getAbstractSession().isInTransaction()) break block42;
                    try {
                        for (int count = 0; this.getAbstractSession().isInTransaction() && count < 10; ++count) {
                            this.getAbstractSession().rollbackTransaction();
                        }
                    }
                    catch (Throwable count) {}
                    TestProblemException problem = new TestProblemException(this + " is a faulty test, transaction was left open and must always be closed.");
                    problem.setInternalException(this.getTestException());
                    this.setTestException(problem);
                    throw problem;
                }
            }
        }
    }

    protected void setUp() throws Exception {
        try {
            this.setup();
        }
        catch (Throwable exception) {
            if (exception instanceof Exception) {
                throw (Exception)exception;
            }
            throw new TestErrorException("Fatal errored in setUp.", exception);
        }
    }

    protected void tearDown() throws Exception {
        try {
            this.reset();
            this.resetVerify();
        }
        catch (Throwable exception) {
            if (exception instanceof Exception) {
                throw (Exception)exception;
            }
            throw new TestErrorException("Fatal errored in tearDown.", exception);
        }
    }

    public void runBare() throws Throwable {
        TestExecutor executor = this.getExecutor();
        if (executor == null) {
            executor = TestExecutor.getDefaultExecutor();
        }
        try {
            this.execute(executor);
        }
        catch (TestWarningException exception) {
            System.out.println("WARNING: " + (Object)((Object)exception));
        }
    }

    @Override
    public TestEntity getContainer() {
        return this.container;
    }

    public String getDescription() {
        return this.description;
    }

    public TestExecutor getExecutor() {
        return this.executor;
    }

    public String getIndentationString() {
        return this.indentationString;
    }

    @Override
    public int getNestedCounter() {
        return this.nestedCounter;
    }

    @Override
    public ResultInterface getReport() {
        return this.getTestResult();
    }

    public EntityManager createEntityManager() {
        return this.getExecutor().createEntityManager();
    }

    public DatabaseSession getDatabaseSession() {
        return (DatabaseSession)this.getExecutor().getSession();
    }

    public AbstractSession getAbstractSession() {
        return (AbstractSession)this.getExecutor().getSession();
    }

    public Session getSession() {
        return this.getExecutor().getSession();
    }

    public Server getServerSession() {
        return (Server)this.getExecutor().getSession();
    }

    public void beginTransaction() {
        this.getAbstractSession().beginTransaction();
    }

    public void commitTransaction() {
        this.getAbstractSession().commitTransaction();
    }

    public void rollbackTransaction() {
        this.getAbstractSession().rollbackTransaction();
    }

    public EclipseLinkException getTestException() {
        return this.getTestResult().getException();
    }

    public TestResult getTestResult() {
        return this.testResult;
    }

    @Override
    public void incrementNestedCounter() {
        this.setNestedCounter(this.getNestedCounter() + 1);
    }

    @Override
    public void logRegressionResult(Writer log) {
        this.computeNestedLevel();
        this.setIndentationString(Helper.getTabs((int)this.getNestedCounter()));
        try {
            log.write(Helper.cr() + this.getIndentationString() + "TEST NAME:   " + this.getName() + Helper.cr());
            log.write(this.getIndentationString() + "TEST DESCRIPTION: " + this.getDescription() + Helper.cr());
            log.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.getTestResult().logRegressionResult(log);
    }

    @Override
    public void logResult(Writer log, boolean shouldLogOnlyErrors) {
        this.logResult(log);
    }

    @Override
    public void logResult(Writer log) {
        this.computeNestedLevel();
        this.setIndentationString(Helper.getTabs((int)this.getNestedCounter()));
        try {
            log.write(Helper.cr() + this.getIndentationString() + "VERSION:   " + DatabaseLogin.getVersion());
            log.write(Helper.cr() + this.getIndentationString() + "TEST NAME:   " + this.getName() + Helper.cr());
            log.write(this.getIndentationString() + "TEST DESCRIPTION: " + this.getDescription() + Helper.cr());
            log.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.getTestResult().logResult(log);
    }

    @Override
    public boolean requiresDatabase() {
        return true;
    }

    public void reset() throws Throwable {
    }

    @Override
    public void resetEntity() {
        try {
            this.reset();
        }
        catch (Throwable runtimeException) {
            TestProblemException validationException = new TestProblemException("Reset problem occurred.", runtimeException);
            if (this.getTestException() == null) {
                this.setTestException(validationException);
            }
            throw validationException;
        }
    }

    @Override
    public void resetNestedCounter() {
        this.setNestedCounter(-1);
    }

    protected void resetVerify() throws Throwable {
    }

    @Override
    public void setContainer(TestEntity testEntity) {
        this.container = testEntity;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setExecutor(TestExecutor anExecutor) {
        this.executor = anExecutor;
    }

    public void setIndentationString(String indentationString) {
        this.indentationString = indentationString;
    }

    @Override
    public void setNestedCounter(int level) {
        this.nestedCounter = level;
    }

    public void setTestException(EclipseLinkException exception) {
        this.getTestResult().setException(exception);
    }

    @Override
    public void setReport(ResultInterface testResult) {
        this.setTestResult((TestResult)testResult);
    }

    public void setTestResult(TestResult testResult) {
        this.testResult = testResult;
        testResult.setTestCase(this);
    }

    protected void setup() throws Throwable {
    }

    protected void runTest() throws Throwable {
    }

    public void executeTest() throws Throwable {
        this.test();
    }

    protected void test() throws Throwable {
        this.runTest();
    }

    public String toString() {
        return this.getName();
    }

    protected void verify() throws Throwable {
    }

    public void throwError(String message) {
        throw new TestErrorException(message);
    }

    public void throwError(String message, Throwable exception) {
        throw new TestErrorException(message, exception);
    }

    public void throwWarning(String message) {
        throw new TestWarningException(message);
    }

    public void strongAssert(boolean assertion, String errorMessage) {
        if (!assertion) {
            throw new TestErrorException(errorMessage);
        }
    }

    public void weakAssert(boolean assertion, String warningMessage) {
        if (!assertion) {
            throw new TestWarningException(warningMessage);
        }
    }

    private boolean isLocalTest() {
        return this.getClass().getName().endsWith("Local");
    }

    public void cleanAfterExecuteFailed() {
    }

    public void checkSelectForUpateSupported() {
        DatabasePlatform platform = this.getSession().getPlatform();
        if (platform.isFirebird() || platform.isAccess() || platform.isSybase() || platform.isSQLAnywhere() || platform.isDerby() || platform.isHSQL() || platform.isSymfoware()) {
            throw new TestWarningException("This database does not support FOR UPDATE");
        }
    }

    public void checkNoWaitSupported() {
        DatabasePlatform platform = this.getSession().getPlatform();
        if (!(platform.isOracle() || platform.isSQLServer() || platform.isPostgreSQL())) {
            throw new TestWarningException("This database does not support NOWAIT");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SessionEventAdapter checkTransactionIsolation() {
        SessionEventAdapter listener;
        DatabasePlatform platform = this.getSession().getPlatform();
        if (platform.isSybase()) {
            if (!SybaseTransactionIsolationListener.isDatabaseVersionSupported((ServerSession)this.getAbstractSession().getParent())) throw new TestWarningException("The test requires Sybase version " + SybaseTransactionIsolationListener.requiredVersion + " or higher");
            listener = new SybaseTransactionIsolationListener();
        } else {
            if (platform.isSQLServer()) {
                throw new TestWarningException("This test requires transaction isolation setup on SQLServer database which is currently not set in tlsvrdb6");
            }
            if (platform.isSQLAnywhere()) {
                throw new TestWarningException("This test requires transaction isolation setup on SQLAnywhere database which is currently not set");
            }
            if (platform.isDB2()) {
                throw new TestWarningException("This test requires transaction isolation setup on DB2 database which is currently not set");
            }
            if (platform.isSymfoware()) {
                listener = new TransactionIsolationLevelSwitchListener();
            } else {
                if (!platform.isMaxDB()) return null;
                listener = new JDBCIsoLevelSwitchListener();
            }
        }
        this.getAbstractSession().getParent().getEventManager().addListener((SessionEventListener)listener);
        return listener;
    }

    public static boolean supportsStoredProcedures(Session session) {
        DatabasePlatform platform = session.getPlatform();
        return platform.isOracle() || platform.isSybase() || platform.isMySQL() || platform.isSQLServer() || platform.isSymfoware();
    }

    public void forceGC() {
        WeakReference<Object> ref = new WeakReference<Object>(new Object());
        for (int loops = 0; loops < 10; ++loops) {
            for (int i = 0; i < 10; ++i) {
            }
            System.gc();
            System.runFinalization();
        }
        if (ref.get() != null) {
            System.out.println("WARNING: gc did not occur");
        }
    }
}

